/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.configuration.impl;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.xpandit.xray.configuration.ServerConfig;
import com.xpandit.xray.model.CredentialData;
import com.xpandit.xray.model.XrayInstance;
import com.xpandit.xray.security.XraySecurityService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerConfigImpl
implements ServerConfig {
    public static final String SERVER_CONFIG = "com.xpandit.xray.xrayserverconfiguration";
    private static final String SEED = "com.xpandit.xray.xrayserverconfiguration.seed";
    private static final String FAKE_PASSWORD = "@@RAVEN_PRESUME_OPPRESSED_CUSTARD_PROMPTLY@@";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final XraySecurityService xraySecurityService;

    public ServerConfigImpl(PluginSettingsFactory pluginSettingsFactory, XraySecurityService xraySecurityService) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.xraySecurityService = xraySecurityService;
    }

    @Override
    public List<CredentialData> getPluginSettings() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Map credentialTable = (Map)pluginSettings.get(SERVER_CONFIG);
        ArrayList<CredentialData> credentialResult = new ArrayList<CredentialData>();
        if (credentialTable != null && !credentialTable.isEmpty()) {
            for (Map map : credentialTable.values()) {
                CredentialData credentialData = new CredentialData();
                credentialData.setROWID((String)map.get("ROWID"));
                credentialData.setName((String)map.get("name"));
                credentialData.setServerAddress((String)map.get("serverAddress"));
                credentialData.setUser((String)map.get("user"));
                credentialData.setPassword(FAKE_PASSWORD);
                credentialResult.add(credentialData);
            }
        }
        return credentialResult;
    }

    @Override
    public boolean savePluginSettings(Map<String, String> credentialMap) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        HashMap<String, Map<String, String>> credentialTable = (HashMap<String, Map<String, String>>)pluginSettings.get(SERVER_CONFIG);
        if (pluginSettings.get(SEED) == null) {
            pluginSettings.put(SEED, (Object)String.valueOf(0));
        } else {
            long seed = Long.parseLong((String)pluginSettings.get(SEED)) + 1L;
            pluginSettings.put(SEED, (Object)String.valueOf(seed));
        }
        if (credentialTable != null && !credentialTable.isEmpty()) {
            for (Map credential : credentialTable.values()) {
                if (!((String)credential.get("name")).trim().equals(credentialMap.get("name").trim())) continue;
                return false;
            }
        } else {
            credentialTable = new HashMap<String, Map<String, String>>();
        }
        credentialMap.put("ROWID", (String)pluginSettings.get(SEED));
        credentialMap.put("password", this.xraySecurityService.encrypt(credentialMap.get("password")));
        credentialTable.put(credentialMap.get("ROWID"), credentialMap);
        pluginSettings.put(SERVER_CONFIG, credentialTable);
        return true;
    }

    @Override
    public boolean editPluginSettings(Map<String, String> credentialMap) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Map credentialTable = (Map)pluginSettings.get(SERVER_CONFIG);
        Map oldSettings = (Map)credentialTable.get(credentialMap.get("ROWID"));
        if (credentialTable != null && !credentialTable.isEmpty()) {
            for (Map credential : credentialTable.values()) {
                if (((String)credential.get("ROWID")).equalsIgnoreCase(credentialMap.get("ROWID")) || this.validateSettings(credential, credentialMap)) continue;
                return false;
            }
            if (oldSettings != null) {
                Map<String, String> newSettings = this.getNewSettings(oldSettings, credentialMap);
                credentialTable.put(credentialMap.get("ROWID"), newSettings);
                pluginSettings.put(SERVER_CONFIG, (Object)credentialTable);
                return true;
            }
        }
        return false;
    }

    @Override
    public void removePluginSettings(Map<String, String> credentialMap) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Map credentialTable = (Map)pluginSettings.get(SERVER_CONFIG);
        if (credentialTable != null && !credentialTable.isEmpty()) {
            credentialTable.remove(credentialMap.get("ROWID"));
        }
        pluginSettings.put(SERVER_CONFIG, (Object)credentialTable);
    }

    @Override
    public Map<String, String> getServers() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Map credentialTable = (Map)pluginSettings.get(SERVER_CONFIG);
        HashMap<String, String> servers = new HashMap<String, String>();
        if (credentialTable != null && !credentialTable.isEmpty()) {
            for (Map credential : credentialTable.values()) {
                servers.put((String)credential.get("ROWID"), (String)credential.get("name"));
            }
        }
        return servers;
    }

    @Override
    public XrayInstance getXrayInstance(String rowID) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Map credentialTable = (Map)pluginSettings.get(SERVER_CONFIG);
        if (credentialTable != null && credentialTable.containsKey(rowID)) {
            Map credential = (Map)credentialTable.get(rowID);
            return new XrayInstance((String)credential.get("serverAddress"), (String)credential.get("user"), this.xraySecurityService.decrypt((String)credential.get("password")));
        }
        return null;
    }

    private Map<String, String> getNewSettings(Map<String, String> oldSettings, Map<String, String> newSettings) {
        HashMap<String, String> newSettingsMerged = new HashMap<String, String>(oldSettings);
        for (Map.Entry<String, String> entry : newSettings.entrySet()) {
            String key = entry.getKey();
            String newSetting = entry.getValue();
            if (key.equals("password") && FAKE_PASSWORD.equals(newSetting)) {
                newSetting = oldSettings.get("password");
            } else if (key.equals("password")) {
                newSetting = this.xraySecurityService.encrypt(newSetting);
            }
            newSettingsMerged.put(key, newSetting);
        }
        return newSettingsMerged;
    }

    private boolean validateSettings(Map<String, String> oldSettings, Map<String, String> newSettings) {
        String oldServerConfig = oldSettings.get("name");
        String newServerConfig = newSettings.get("name");
        return !oldServerConfig.trim().equals(newServerConfig.trim());
    }
}

