/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.action;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.xpandit.xray.configuration.ServerConfig;
import com.xpandit.xray.model.XrayInstance;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class XrayPrequeueAction
implements CustomPreBuildQueuedAction {
    private BuildContext buildContext;
    private ServerConfig serverConfig;
    private BuildLoggerManager buildLoggerManager;
    private BuildLogger buildLogger;

    public void init(@NotNull BuildContext buildContext) {
        this.setBuildContext(buildContext);
        this.setBuildLogger(this.buildLoggerManager.getLogger((ResultKey)buildContext.getPlanResultKey()));
    }

    @NotNull
    public BuildContext call() {
        BuildDefinition buildDefinition = this.buildContext.getBuildDefinition();
        List<TaskDefinition> xrayBuildTasks = buildDefinition.getTaskDefinitions().stream().filter(this::isActiveXrayTask).collect(Collectors.toList());
        if (!xrayBuildTasks.isEmpty()) {
            this.buildLogger.addBuildLogEntry("Executing Xray Actions for the following build: " + this.buildContext.getDisplayName());
            xrayBuildTasks.forEach(this::resolveServerConfiguration);
        }
        return this.buildContext;
    }

    private void resolveServerConfiguration(TaskDefinition td) {
        String xrayInstanceID;
        this.buildLogger.addBuildLogEntry("Resolving context information for task with user description: " + td.getUserDescription());
        String string = xrayInstanceID = td.getConfiguration().get("server") != null ? (String)td.getConfiguration().get("server") : (String)td.getConfiguration().get("importServer");
        if (xrayInstanceID == null) {
            return;
        }
        XrayInstance xrayInstance = this.serverConfig.getXrayInstance(xrayInstanceID);
        String taskFullID = this.buildContext.getPlanResultKey().getPlanKey() + "-" + td.getId();
        this.buildContext.getBuildResult().getCustomBuildData().put(taskFullID + "serverAddress", xrayInstance.getServerAddress());
        this.buildContext.getBuildResult().getCustomBuildData().put(taskFullID + "user", xrayInstance.getUsername());
        this.buildContext.getBuildResult().getCustomBuildData().put(taskFullID + "password", xrayInstance.getPassword());
        this.buildLogger.addBuildLogEntry("Jira instance selected: " + xrayInstance.getServerAddress());
    }

    private boolean isActiveXrayTask(TaskDefinition td) {
        return td.getPluginKey().contains("xray-bamboo") && td.isEnabled();
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public BuildLoggerManager getBuildLoggerManager() {
        return this.buildLoggerManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public void setBuildLogger(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }
}

