
<script>
	(function($){
		  var formats = ${formats};
		  
		  addXrayFields = function(){
			var key = AJS.$("select[name=format]").find('option:selected').text();

			var selectedFormat = formats[key]; //definition of the selected format, it is used to render the dynamic fields
			if(selectedFormat && selectedFormat.configurableFields && selectedFormat.configurableFields.length > 0){
							
				//call soy
				var parametersHtml = XrayBamboo.ImportTask.addFields({fields: selectedFormat.configurableFields});
				
				if(AJS.$(".xray-parameters-container").length){
					AJS.$(".xray-parameters-container").html(parametersHtml);
				}else{
					var container = "<div class='xray-parameters-container'>"+parametersHtml+"</div>";
					AJS.$("select[name=format]").after(container);
				}	
				
				switcherLastConfiguration();
			}else if(AJS.$(".xray-parameters-container").length){
				AJS.$(".xray-parameters-container").empty();
			}
		}	
	
		/*
		* Switches the HTML element for the importInfo field
		*/
		switchInput = function(container){	
			//current selected input type, from the select HTML element	
			var selectedInputType = AJS.$("#selectInputType").find('option:selected').val(); 
			
			var key = AJS.$("select[name=format]").find('option:selected').text();
			
			//selected input type, from last configuration
			var lastSwitcherConfig = '${inputInfoSwitcher}';
			
			//field to render
			var _field = (formats[key]).configurableFields.filter(function(field){return field.key == 'importInfo'})[0];
					
			var renderConfiguration = (lastSwitcherConfig == selectedInputType);

			if(selectedInputType == 'filePath'){
				var inputFieldHtml = XrayBamboo.ImportTask.addInput({field:_field,renderLabel:false,renderConfig:renderConfiguration});
				AJS.$(container).html(inputFieldHtml);	
			}
			else if(selectedInputType == 'fileContent'){ // content is in JSON format
			    var inputFieldHtml = XrayBamboo.ImportTask.addTextarea({field:_field,renderConfig:renderConfiguration});
				AJS.$(container).html(inputFieldHtml);	
				prettify();
			}		
		}
		
		/*
		* Formats the JSON content when the HTML element for the importInfo field is a textarea
		*/
		prettify = function(){
		    var textarea = AJS.$(".textarea_fileContent");
			var ugly = textarea[0].value;
			if(ugly){
				try {
					var formated = JSON.stringify(JSON.parse(ugly), undefined, 3);
					textarea.html(formated);
				}catch(err){
					
				}
			}
		}
		
		switcherLastConfiguration = function(){
			//selected input type, from last configuration
			var lastSwitcherConfig = '${inputInfoSwitcher}';

			if(lastSwitcherConfig !== '' ){//making sure the switcher gets the last configuration value
				var select = AJS.$("#selectInputType");
				if(select){
					select.val(lastSwitcherConfig);
					select.trigger('change');
				}
			}
			
		}

	    $(document).ready(function() {
			AJS.$("select[name=format]").trigger("change"); //making sure that the select gets the last configuration value
	    });
	    
   })(AJS.$);			
</script>
[@ww.select labelKey="import-cucumber-features.server-param" name="importServer" required="true" list="serverMap" headerKey="-1" headerValue="Select a Jira instance" listKey="key" listValue="value" value="importServer" toggle=true /]
[@ww.select labelKey="import-cucumber-features.format-param" name="format" required="true" list="formatList" listKey="value" listValue="key" value="format" toggle=true onchange="addXrayFields()"/]

<a target="_blank" href="https://confluence.xpand-it.com/display/XRAY/Import+Execution+Results+-+REST">Click here for more details</a>
