/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.service.impl.XrayExporterImpl;
import com.xpandit.xray.service.impl.delegates.authentication.UsernamePasswordAuthentication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

public class ExportCucumberFeaturesTask
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        String filterId;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Export Cucumber features Task started ... version with Client Core");
        buildLogger.addBuildLogEntry("##########################################################");
        buildLogger.addBuildLogEntry("####   Xray for Jira is generating the feature files  ####");
        buildLogger.addBuildLogEntry("##########################################################");
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed();
        String taskFullID = taskContext.getBuildContext().getPlanResultKey().getPlanKey() + "-" + taskContext.getId();
        String serverAddress = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "serverAddress");
        String username = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "user");
        String password = (String)taskContext.getBuildContext().getBuildResult().getCustomBuildData().get(taskFullID + "password");
        if (StringUtils.isBlank((CharSequence)serverAddress) || StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            buildLogger.addErrorLogEntry("No valid Jira instance configuration found for this task. Please associate a valid configuration");
            return builder.build();
        }
        XrayExporterImpl client = new XrayExporterImpl(serverAddress, new UsernamePasswordAuthentication(username, password), null);
        buildLogger.addBuildLogEntry("Downloading content from Jira instance: " + serverAddress);
        String inputIssues = (String)taskContext.getConfigurationMap().get((Object)"issues");
        if (inputIssues != null && !StringUtils.isEmpty((CharSequence)inputIssues)) {
            buildLogger.addBuildLogEntry(inputIssues);
        }
        if ((filterId = (String)taskContext.getConfigurationMap().get((Object)"filter")) != null && !StringUtils.isEmpty((CharSequence)filterId)) {
            buildLogger.addBuildLogEntry(filterId);
        }
        try (InputStream file = client.downloadFeatures(inputIssues, filterId, "true");){
            this.unzipFeatures(buildLogger, taskContext.getRootDirectory(), (String)taskContext.getConfigurationMap().get((Object)"filePath"), file);
        }
        catch (XrayClientCoreGenericException | IOException e) {
            buildLogger.addErrorLogEntry(e.getMessage());
            e.printStackTrace();
            return builder.build();
        }
        builder.success();
        buildLogger.addBuildLogEntry("Export Cucumber features Task finished successfully.");
        return builder.build();
    }

    private void unzipFeatures(BuildLogger buildLogger, File root, String filePath, InputStream zip) throws IOException {
        int length;
        if (filePath == null || StringUtils.isEmpty((CharSequence)filePath)) {
            filePath = "features/";
        }
        File outputFile = new File(root, filePath);
        outputFile.mkdirs();
        FileOutputStream fos = new FileOutputStream(new File(outputFile, "features.zip"));
        byte[] buffer = new byte[4096];
        while ((length = zip.read(buffer)) > 0) {
            fos.write(buffer, 0, length);
        }
        buildLogger.addBuildLogEntry("###################### Unzipping file ####################");
        ZipInputStream zis = new ZipInputStream(new FileInputStream(root + "/" + filePath + "/features.zip"));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int len;
            String fileName = ze.getName();
            File newFile = new File(root, filePath + "/" + fileName);
            new File(newFile.getParent()).mkdirs();
            fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        zip.close();
        buildLogger.addBuildLogEntry("###################### Unzipped file #####################");
    }
}

