/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.Content;
import com.xpandit.xray.model.DataParameter;
import com.xpandit.xray.model.Endpoint;
import com.xpandit.xray.model.FilePath;
import com.xpandit.xray.model.FileStream;
import com.xpandit.xray.model.QueryParameter;
import com.xpandit.xray.model.StringContent;
import com.xpandit.xray.model.UploadResult;
import com.xpandit.xray.service.impl.delegates.HttpCloudRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpServerRequestProvider;
import com.xpandit.xray.service.impl.delegates.UploadResponseResolverDelegate;
import com.xpandit.xray.util.StringUtil;
import com.xpandit.xray.util.URLConstructor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadDelegate {
    private static Logger logger = LogManager.getLogger(UploadDelegate.class);
    private final HttpRequestProvider httpProvider;

    public UploadDelegate(HttpRequestProvider httpRequestProvider) {
        this.httpProvider = httpRequestProvider;
    }

    public UploadResult uploadResults(Endpoint endpoint, Map<DataParameter, Content> map, Map<QueryParameter, String> map2) throws XrayClientCoreGenericException {
        switch (endpoint) {
            case XRAY: {
                return this.uploadXrayResults(map.get(DataParameter.FILEPATH));
            }
            case XRAY_MULTIPART: {
                return this.uploadXrayMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO));
            }
            case CUCUMBER: {
                return this.uploadCucumberResults(map.get(DataParameter.FILEPATH));
            }
            case BEHAVE: {
                return this.uploadBehaveResults(map.get(DataParameter.FILEPATH));
            }
            case CUCUMBER_MULTIPART: {
                return this.uploadCucumberMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO));
            }
            case BEHAVE_MULTIPART: {
                return this.uploadBehaveMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO));
            }
            case JUNIT: {
                return this.uploadJUnitResults(map.get(DataParameter.FILEPATH), map2.get(QueryParameter.PROJECT_KEY), map2.get(QueryParameter.TEST_EXEC_KEY), map2.get(QueryParameter.TEST_PLAN_KEY), map2.get(QueryParameter.TEST_ENVIRONMENTS), map2.get(QueryParameter.REVISION), map2.get(QueryParameter.FIX_VERSION));
            }
            case JUNIT_MULTIPART: {
                return this.uploadJUnitMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO), map.get(DataParameter.TEST_INFO));
            }
            case TESTNG: {
                return this.uploadTestNGResults(map.get(DataParameter.FILEPATH), map2.get(QueryParameter.PROJECT_KEY), map2.get(QueryParameter.TEST_EXEC_KEY), map2.get(QueryParameter.TEST_PLAN_KEY), map2.get(QueryParameter.TEST_ENVIRONMENTS), map2.get(QueryParameter.REVISION), map2.get(QueryParameter.FIX_VERSION));
            }
            case TESTNG_MULTIPART: {
                return this.uploadTestNGMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO), map.get(DataParameter.TEST_INFO));
            }
            case NUNIT: {
                return this.uploadNUnitResults(map.get(DataParameter.FILEPATH), map2.get(QueryParameter.PROJECT_KEY), map2.get(QueryParameter.TEST_EXEC_KEY), map2.get(QueryParameter.TEST_PLAN_KEY), map2.get(QueryParameter.TEST_ENVIRONMENTS), map2.get(QueryParameter.REVISION), map2.get(QueryParameter.FIX_VERSION));
            }
            case NUNIT_MULTIPART: {
                return this.uploadNUnitMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO), map.get(DataParameter.TEST_INFO));
            }
            case ROBOT: {
                return this.uploadRobotResults(map.get(DataParameter.FILEPATH), map2.get(QueryParameter.PROJECT_KEY), map2.get(QueryParameter.TEST_EXEC_KEY), map2.get(QueryParameter.TEST_PLAN_KEY), map2.get(QueryParameter.TEST_ENVIRONMENTS), map2.get(QueryParameter.REVISION), map2.get(QueryParameter.FIX_VERSION));
            }
            case ROBOT_MULTIPART: {
                return this.uploadRobotMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO), map.get(DataParameter.TEST_INFO));
            }
            case BUNDLE: {
                if (this.isServerInstance()) {
                    return this.uploadBundledResults(map.get(DataParameter.FILEPATH));
                }
                throw new NotImplementedException("Bundle Endpoint is not implemented for Xray Cloud.");
            }
            case XUNIT: {
                return this.uploadXUnitResults(map.get(DataParameter.FILEPATH), map2.get(QueryParameter.PROJECT_KEY), map2.get(QueryParameter.TEST_EXEC_KEY), map2.get(QueryParameter.TEST_PLAN_KEY), map2.get(QueryParameter.TEST_ENVIRONMENTS), map2.get(QueryParameter.REVISION), map2.get(QueryParameter.FIX_VERSION));
            }
            case XUNIT_MULTIPART: {
                return this.uploadXUnitMultipartResults(map.get(DataParameter.FILEPATH), map.get(DataParameter.INFO), map.get(DataParameter.TEST_INFO));
            }
        }
        logger.error("Endpoint not recognized by Xray REST API");
        throw new XrayClientCoreGenericException("Endpoint not recognized by Xray REST API");
    }

    public UploadResult uploadXrayResults(Content content) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.XRAY;
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadRawTestResults(string, content);
    }

    public UploadResult uploadXrayMultipartResults(Content content, Content content2) {
        return this.resolveGenericMultipart(Endpoint.XRAY_MULTIPART, content, content2);
    }

    public UploadResult uploadCucumberResults(Content content) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.CUCUMBER;
        String string = this.httpProvider.getBaseUrl() + this.httpProvider.getEndpointImportPrefix() + endpoint.getSuffix();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadRawTestResults(string, content);
    }

    public UploadResult uploadCucumberMultipartResults(Content content, Content content2) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.CUCUMBER_MULTIPART;
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        if (!content2.isDefined()) {
            String string3 = "Unable to upload " + endpoint.getName() + " results: Please provide the test execution fields info";
            logger.error(string3);
            throw new XrayClientCoreGenericException(string3);
        }
        HashMap<String, Content> hashMap = new HashMap<String, Content>();
        hashMap.put("info", content2);
        if (this.isCloudInstance()) {
            hashMap.put("results", content);
        } else {
            hashMap.put("result", content);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadMultipartTestResults(string, hashMap);
    }

    public UploadResult uploadBehaveResults(Content content) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.BEHAVE;
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadRawTestResults(string, content);
    }

    public UploadResult uploadBehaveMultipartResults(Content content, Content content2) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.BEHAVE_MULTIPART;
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        if (!content2.isDefined()) {
            String string3 = "Unable to upload " + endpoint.getName() + " results: Please provide the test execution fields info";
            logger.error(string3);
            throw new XrayClientCoreGenericException(string3);
        }
        HashMap<String, Content> hashMap = new HashMap<String, Content>();
        hashMap.put("info", content2);
        if (this.isCloudInstance()) {
            hashMap.put("results", content);
        } else {
            hashMap.put("result", content);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadMultipartTestResults(string, hashMap);
    }

    public UploadResult uploadJUnitResults(Content content, String string, String string2, String string3, String string4, String string5, String string6) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.JUNIT;
        return this.resolveGeneric(endpoint, content, string, string2, string3, string4, string5, string6);
    }

    public UploadResult uploadJUnitMultipartResults(Content content, Content content2, Content content3) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.JUNIT_MULTIPART;
        return this.resolveGenericMultipart(endpoint, content, content2, content3);
    }

    public UploadResult uploadTestNGResults(Content content, String string, String string2, String string3, String string4, String string5, String string6) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.TESTNG;
        return this.resolveGeneric(endpoint, content, string, string2, string3, string4, string5, string6);
    }

    public UploadResult uploadTestNGMultipartResults(Content content, Content content2, Content content3) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.TESTNG_MULTIPART;
        return this.resolveGenericMultipart(endpoint, content, content2, content3);
    }

    public UploadResult uploadNUnitResults(Content content, String string, String string2, String string3, String string4, String string5, String string6) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.NUNIT;
        return this.resolveGeneric(endpoint, content, string, string2, string3, string4, string5, string6);
    }

    public UploadResult uploadNUnitMultipartResults(Content content, Content content2, Content content3) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.NUNIT_MULTIPART;
        return this.resolveGenericMultipart(endpoint, content, content2, content3);
    }

    public UploadResult uploadRobotResults(Content content, String string, String string2, String string3, String string4, String string5, String string6) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.ROBOT;
        return this.resolveGeneric(endpoint, content, string, string2, string3, string4, string5, string6);
    }

    public UploadResult uploadRobotMultipartResults(Content content, Content content2, Content content3) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.ROBOT_MULTIPART;
        return this.resolveGenericMultipart(endpoint, content, content2, content3);
    }

    public UploadResult uploadXUnitResults(Content content, String string, String string2, String string3, String string4, String string5, String string6) {
        Endpoint endpoint = Endpoint.XUNIT;
        return this.resolveGeneric(endpoint, content, string, string2, string3, string4, string5, string6);
    }

    public UploadResult uploadXUnitMultipartResults(Content content, Content content2, Content content3) {
        Endpoint endpoint = Endpoint.XUNIT_MULTIPART;
        return this.resolveGenericMultipart(endpoint, content, content2, content3);
    }

    public UploadResult uploadBundledResults(Content content) throws XrayClientCoreGenericException {
        Endpoint endpoint = Endpoint.BUNDLE;
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the bundled execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        HashMap<String, Content> hashMap = new HashMap<String, Content>();
        hashMap.put("file", content);
        return this.uploadMultipartTestResults(string, hashMap);
    }

    private UploadResult resolveGenericMultipart(Endpoint endpoint, Content content, Content content2) throws XrayClientCoreGenericException {
        return this.resolveGenericMultipart(endpoint, content, content2, null);
    }

    private UploadResult resolveGenericMultipart(Endpoint endpoint, Content content, Content content2, Content content3) throws XrayClientCoreGenericException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        HashMap<String, Content> hashMap = new HashMap<String, Content>();
        if (!content.isDefined()) {
            String string2 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string2);
            throw new XrayClientCoreGenericException(string2);
        }
        if (!content2.isDefined()) {
            String string3 = "Unable to upload " + endpoint.getName() + " results: Please provide the test execution fields info";
            logger.error(string3);
            throw new XrayClientCoreGenericException(string3);
        }
        hashMap.put(this.getResultFileParamName(endpoint), content);
        hashMap.put(this.getInfoFileParamName(endpoint), content2);
        if (content3 != null && content3.isDefined()) {
            hashMap.put(this.getTestInfoFileParamName(endpoint), content3);
        }
        logger.info("Uploading features to " + endpoint.getName() + " endpoint");
        return this.uploadMultipartTestResults(string, hashMap);
    }

    private String getInfoFileParamName(Endpoint endpoint) {
        if (this.isServerInstance() && StringUtils.isNotBlank((CharSequence)endpoint.getInfoFileServerParamName())) {
            return endpoint.getInfoFileServerParamName();
        }
        if (this.isCloudInstance() && StringUtils.isNotBlank((CharSequence)endpoint.getInfoFileCloudParamName())) {
            return endpoint.getInfoFileCloudParamName();
        }
        return "info";
    }

    private String getTestInfoFileParamName(Endpoint endpoint) {
        if (this.isServerInstance() && StringUtils.isNotBlank((CharSequence)endpoint.getTestInfoFileServerParamName())) {
            return endpoint.getTestInfoFileServerParamName();
        }
        if (this.isCloudInstance() && StringUtils.isNotBlank((CharSequence)endpoint.getTestInfoFileCloudParamName())) {
            return endpoint.getTestInfoFileCloudParamName();
        }
        return "testInfo";
    }

    private String getResultFileParamName(Endpoint endpoint) {
        if (this.isCloudInstance()) {
            if (StringUtils.isNotBlank((CharSequence)endpoint.getResultsFileCloudParamName())) {
                return endpoint.getResultsFileCloudParamName();
            }
            return "results";
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getResultsFileServerParamName())) {
            return endpoint.getResultsFileServerParamName();
        }
        return "file";
    }

    private UploadResult resolveGeneric(Endpoint endpoint, Content content, String string, String string2, String string3, String string4, String string5, String string6) throws XrayClientCoreGenericException {
        StringBuilder stringBuilder = new StringBuilder();
        String string7 = stringBuilder.append(this.httpProvider.getBaseUrl()).append(this.httpProvider.getEndpointImportPrefix()).append(endpoint.getSuffix()).toString();
        HashMap<QueryParameter, String> hashMap = new HashMap<QueryParameter, String>();
        HashMap<String, Content> hashMap2 = new HashMap<String, Content>();
        if (!content.isDefined()) {
            String string8 = "Unable to upload " + endpoint.getName() + " results: Please provide the execution results";
            logger.error(string8);
            throw new XrayClientCoreGenericException(string8);
        }
        if (!StringUtil.notBlank(string) && !StringUtil.notBlank(string2)) {
            String string9 = "Unable to upload " + endpoint.getName() + " results: Please provide a project key or test exec key";
            logger.error(string9);
            throw new XrayClientCoreGenericException(string9);
        }
        hashMap.put(QueryParameter.PROJECT_KEY, string);
        hashMap.put(QueryParameter.TEST_EXEC_KEY, string2);
        hashMap.put(QueryParameter.TEST_PLAN_KEY, string3);
        hashMap.put(QueryParameter.TEST_ENVIRONMENTS, string4);
        hashMap.put(QueryParameter.REVISION, string5);
        hashMap.put(QueryParameter.FIX_VERSION, string6);
        try {
            String string10 = URLConstructor.constructURL(string7, hashMap);
            logger.info("Uploading features to " + endpoint.getName() + " endpoint");
            if (this.isServerInstance()) {
                hashMap2.put("file", content);
                return this.uploadMultipartTestResults(string10, hashMap2);
            }
            if (this.isCloudInstance()) {
                return this.uploadRawTestResults(string10, content);
            }
            throw new XrayClientCoreGenericException("Found new implementation of HttpProvider.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException.getMessage());
            unsupportedEncodingException.printStackTrace();
            throw new XrayClientCoreGenericException(unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UploadResult uploadRawTestResults(String string, Content content) throws XrayClientCoreGenericException {
        InputStreamEntity inputStreamEntity;
        Serializable serializable;
        Content<String> content2;
        UploadResponseResolverDelegate uploadResponseResolverDelegate = new UploadResponseResolverDelegate();
        if (content instanceof FilePath) {
            content2 = (FilePath)content;
            serializable = new File(((FilePath)content2).getContent().trim());
            this.validateFile((File)serializable);
            try {
                inputStreamEntity = new InputStreamEntity((InputStream)new FileInputStream((File)serializable), ((FilePath)content2).getMediaType());
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error(fileNotFoundException.getMessage());
                fileNotFoundException.printStackTrace();
                throw new XrayClientCoreGenericException("File does not exist");
            }
        } else if (content instanceof FileStream) {
            content2 = (FileStream)content;
            inputStreamEntity = new InputStreamEntity(((FileStream)content2).getContent(), ((FileStream)content2).getMediaType());
        } else {
            if (!(content instanceof StringContent)) {
                logger.error("Request content is not recognized");
                throw new XrayClientCoreGenericException("Request content is not recognized");
            }
            content2 = (StringContent)content;
            inputStreamEntity = new StringEntity(((StringContent)content2).getContent().trim(), ((StringContent)content2).getMediaType());
        }
        try {
            content2 = this.httpProvider.doPostRequest(string, (HttpEntity)inputStreamEntity);
            serializable = null;
            try {
                logger.info("Uploading to: " + string);
                UploadResult uploadResult = uploadResponseResolverDelegate.resolveUploadResponse((CloseableHttpResponse)content2);
                return uploadResult;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (content2 != null) {
                    if (serializable != null) {
                        try {
                            content2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        content2.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            iOException.printStackTrace();
            throw new XrayClientCoreGenericException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UploadResult uploadMultipartTestResults(String string, Map<String, Content> map) throws XrayClientCoreGenericException {
        Object object;
        logger.debug("Selected to upload raw results");
        UploadResponseResolverDelegate uploadResponseResolverDelegate = new UploadResponseResolverDelegate();
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (String object22 : map.keySet()) {
            Content<String> content;
            object = map.get(object22);
            if (object instanceof FilePath) {
                content = (FilePath)object;
                File file = new File(((FilePath)content).getContent().trim());
                this.validateFile(file);
                multipartEntityBuilder.addPart(object22, (ContentBody)new FileBody(file));
                continue;
            }
            if (object instanceof FileStream) {
                content = (FileStream)object;
                multipartEntityBuilder.addPart(object22, (ContentBody)new InputStreamBody(((FileStream)content).getContent(), ((FileStream)content).getMediaType(), ((FileStream)content).getFileName()));
                continue;
            }
            if (!(object instanceof StringContent)) {
                logger.error("Request content is not recognized");
                throw new XrayClientCoreGenericException("Request content is not recognized");
            }
            content = (StringContent)object;
            multipartEntityBuilder.addPart(object22, (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream(((StringContent)content).getContent().getBytes(StandardCharsets.UTF_8)), ((StringContent)content).getMediaType(), "info"));
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse closeableHttpResponse = this.httpProvider.doPostRequest(string, multipartEntityBuilder.build());){
                logger.info("Uploading to: " + string);
                object = uploadResponseResolverDelegate.resolveUploadResponse(closeableHttpResponse);
                return object;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            logger.error("Failed when uploading File", (Throwable)iOException);
            throw new XrayClientCoreGenericException(iOException);
        }
    }

    private void validateFile(File file) throws XrayClientCoreGenericException {
        if (!file.exists()) {
            logger.error("Location does not exist:" + file.getAbsolutePath());
            throw new XrayClientCoreGenericException("Location does not exist");
        }
        if (!file.isFile()) {
            logger.error("Location is not a file:" + file.getAbsolutePath());
            throw new XrayClientCoreGenericException("Location not a File");
        }
    }

    private boolean isCloudInstance() {
        return this.httpProvider instanceof HttpCloudRequestProvider;
    }

    private boolean isServerInstance() {
        return this.httpProvider instanceof HttpServerRequestProvider;
    }
}

