/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.security;

import com.atlassian.bamboo.security.EncryptionService;
import com.xpandit.xray.security.XraySecurityService;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XraySecurityServiceImpl
implements XraySecurityService {
    private static final Logger logger = LoggerFactory.getLogger(XraySecurityServiceImpl.class);
    private final EncryptionService encryptionService;

    public XraySecurityServiceImpl(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    @Override
    @NotNull
    public String encrypt(@Nullable String data) {
        return this.encryptionService.encrypt(data);
    }

    @Override
    @NotNull
    public String decrypt(@Nullable String data) {
        try {
            return this.encryptionService.decrypt(data);
        }
        catch (Exception e) {
            logger.error("Exception while decrypting data", (Throwable)e);
            return StringUtils.defaultString((String)data);
        }
    }
}

