/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.util;

import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.deployit.booter.remote.xml.DescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.MethodDescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.PropertyDescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.RemoteXStreamCiConverter;
import com.xebialabs.deployit.booter.remote.xml.StepConverter;
import com.xebialabs.deployit.booter.remote.xml.TaskConverterSelector;
import com.xebialabs.deployit.ci.bamboo.util.CollectionUtils;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemIdConverter;
import com.xebialabs.xltype.serialization.xstream.ControlConverter;
import com.xebialabs.xltype.serialization.xstream.DeploymentConverter;
import com.xebialabs.xltype.serialization.xstream.InspectionConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooterConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteBooterConfigurer.class);
    protected static final Set<Class<? extends Converter>> XSTREAM_PROVIDER_CLASSES = CollectionUtils.immutableSet(RemoteXStreamCiConverter.class, DescriptorConverter.class, MethodDescriptorConverter.class, PropertyDescriptorConverter.class, StepConverter.class, TaskConverterSelector.class, ConfigurationItemIdConverter.class, ControlConverter.class, DeploymentConverter.class, InspectionConverter.class);

    public static void preconfigure() {
        Scannit.boot((Configuration)Configuration.config());
        for (Converter converter : RemoteBooterConfigurer.allConverters()) {
            LOGGER.debug("Registering XStream converter: {}", (Object)converter);
            XStreamReaderWriter.registerConverter((Converter)converter);
        }
    }

    private static Collection<Converter> allConverters() {
        HashSet<Converter> collection = new HashSet<Converter>();
        for (Class<? extends Converter> convObject : XSTREAM_PROVIDER_CLASSES) {
            if (!Converter.class.isAssignableFrom(convObject)) continue;
            collection.add(RemoteBooterConfigurer.getConverter(convObject));
        }
        return collection;
    }

    private static Converter getConverter(Class<? extends Converter> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

