[#-- @ftlvariable name="action" type="com.valens.deployments.CustomDeploymentVersionAction" --]
[#-- @ftlvariable name="" type="com.valens.deployments.CustomDeploymentVersionAction" --]


${webResourceManager.requireResource("com.valens.deployments.bamboo-custom-deployments:custom-deployments-resources")}
<script type="text/javascript">
    function OnButtonClick(nameofcontrol,stringtoput) {
        var textcontrol = document.getElementsByName(nameofcontrol)[0];
        if(textcontrol.value.trim().length > 0)
            textcontrol.value = textcontrol.value + "${lists}" + stringtoput;
        else
            textcontrol.value = stringtoput;
    }

    function ResetClick(nameofcontrol) {
        var textcontrol = document.getElementsByName(nameofcontrol)[0];

        textcontrol.value = "";
    }

    function handleClick(e, sep, nameofcontrol) {
        var el = document.getElementById(e);
        var textcontrol = document.getElementsByName(nameofcontrol)[0];
        // get reference to input elements in toppings container element
        var tops = el.getElementsByTagName('input');
        var b = 0;
        var val = "";
        // assign updateTotal function to onclick property of each checkbox
        for (var i=0, len=tops.length; i<len; i++) {
            if ( tops[i].checked ) {
                if( b == 1 )
                    val = val + sep;
                b = 1;
                val = val + tops[i].value;
            }
        }
        textcontrol.value = val;
    }

</script>

<div class="aui-page-header-main"><h2>Deploy customized for <b>${environmentName}</b> (latest deployed version:
    ${latestVersion})</h2></div>
<br/>
<div class="plugin-custom-deploy-container" data-provide="plugin-custom-deploy-page" data-page="form">

    [@ww.form class="aui" id="selectVersion" action="/plugins/servlet/deploy/customdeploystart"
    namespace="/plugins/servlet/deploy" cancelUri=cancelUrl!"" ]

    [@ww.hidden name="projectId" value="${projectId}" /]
    [@ww.hidden name="environmentId" value="${environmentId}" /]

    <div class="field-group">
        <label for="versionId">Version</label>
        <select name="versionId" class="aui select full-width-field" rows="30" toggle='true'>
            [#list action.getVersions() as val]
            <option value="${val.id}">${val.name} (created [#if val.getCreatorDisplayName()??] by
                ${val.creatorDisplayName}[/#if] on ${val.creationDate})
            </option>
            [/#list]
        </select>
    </div>

    <h3>Custom variables</h3>

    [#if selectedControl?lower_case?contains("text")]

    [#list variables as variable]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
        <input name="variable_${variable.key}" class="text long-field" type="password"/>
        [#else]
        <input name="variable_${variable.key}" class="text long-field" type="text" value="${variable.value}"/>
        [/#if]
    </div>
    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <input type="button" class="button aui" id="reset${val}" onclick="ResetClick('variable_${variable.key}')"
                   value="Reset"/>
            [#list action.getPossibleValues( variable.key ) as val]
            <input type="button" class="button aui" id="btnsubmit${val}"
                   onclick="OnButtonClick('variable_${variable.key}','${val}')" value="${val}"/>
            [/#list]
            [/#if]
        </div>
    </div>
    [/#list]

    [/#if]

    [#if selectedControl?lower_case?contains("dropdown")]
    [#list variables as variable]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        <select name="variable_${variable.key}" class="text long-field">
            [#list action.getPossibleValues( variable.key ) as val]
            <option value="${val}">${val}</option>
            [/#list]
        </select>
    </div>
    [/#list]
    [/#if]

    [#if selectedControl?lower_case?contains("checkbox")]
    [#list variables as variable]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="password"
              />
        [#else]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="text"
               value="${variable.value}"/>
        [/#if]
    </div>

    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <div id="element_${variable.key}">
                [#list action.getPossibleValues( variable.key ) as val]
                <label><input type='checkbox' class="aui"
                              onclick='handleClick("element_${variable.key}","${lists}","variable_${variable.key}");'
                              value="${val}">${val}</label>
                [/#list]
            </div>
            [/#if]
        </div>
    </div>
    [/#list]
    [/#if]

    [#if selectedControl?lower_case?contains("custom")]
    [#list variables as variable]
    [#if action.getTemplate(variable.key).getType()??]
    [#if action.getTemplate(variable.key).getType()?lower_case?contains("select")]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        <select name="variable_${variable.key}" class="text long-field">
            [#list action.getTemplate(variable.key).getValues() as val]
            <option value="${val}">${val}</option>
            [/#list]
        </select>
    </div>
    [/#if]

    [#if action.getTemplate(variable.key).getType()?lower_case?contains("checkbox")]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="password"
               />
        [#else]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="text"
               value="${variable.value}"/>
        [/#if]
    </div>

    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <div id="element_${variable.key}">
                [#list action.getTemplate( variable.key ).getValues() as val]
                <label><input type='checkbox' class="aui"
                              onclick='handleClick("element_${variable.key}","${action.getTemplate( variable.key ).getSeparator()}","variable_${variable.key}");'
                              value="${val}">${val}</label>

                [/#list]
            </div>
            [/#if]
        </div>
    </div>
    [/#if]

    [#if action.getTemplate(variable.key).getType()?lower_case?contains("text")]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="password"
               />
        [#else]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="text"
               value="${variable.value}"/>
        [/#if]
    </div>
    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <input type="button" class="button aui" id="reset${val}" onclick="ResetClick('variable_${variable.key}')"
                   value="Reset"/>
            [#list action.getTemplate( variable.key ).getValues() as val]
            <input type="button" class="button aui" id="btnsubmit${val}"
                   onclick="OnButtonClick('variable_${variable.key}','${val}')" value="${val}"/>
            [/#list]
            [/#if]
        </div>
    </div>
    [/#if]
    [#else]

    [#if fallbackControl?lower_case?contains("text")]
    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
        <td><input name="variable_${variable.key}" class="text long-field" type="password"/>
        </td>
        [#else]
        <td><input name="variable_${variable.key}" class="text long-field" type="text" value="${variable.value}"/></td>
        [/#if]
    </div>
    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <input type="button" class="button aui" id="reset${val}" onclick="ResetClick('variable_${variable.key}')"
                   value="Reset"/>
            [#list action.getPossibleValues( variable.key ) as val]
            <input type="button" class="button aui" id="btnsubmit${val}"
                   onclick="OnButtonClick('variable_${variable.key}','${val}')" value="${val}"/>
            [/#list]
            [/#if]
        </div>
    </div>
    [/#if]

    [#if fallbackControl?lower_case?contains("dropdown")]

    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        <select name="variable_${variable.key}" class="text long-field">
            [#list action.getPossibleValues( variable.key ) as val]
            <option value="${val}">${val}</option>
            [/#list]
        </select>
    </div>

    [/#if]

    [#if fallbackControl?lower_case?contains("checkbox")]

    <div class="field-group">
        <label for="variable_${variable.key}">${variable.key}</label>
        [#if variable.key?lower_case?contains("password")]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="password"
              />
        [#else]
        <input name="variable_${variable.key}" class="text long-field" autocomplete="off" type="text"
               value="${variable.value}"/>
        [/#if]
    </div>
    <div class="buttons-container">
        <div class="buttons">
            [#if variable.key?lower_case?contains("password") || variable.key?lower_case?contains("passphrase") || variable.key?lower_case?contains("secret") || variable.key?lower_case?contains("sshkey")]
            <p></p>
            [#else]
            <tr>
                <td>&nbsp;</td>
                <td>
                    <div id="element_${variable.key}">
                        [#list action.getPossibleValues( variable.key ) as val]
                        <label><input type='checkbox' class="aui"
                                      onclick='handleClick("element_${variable.key}","${lists}","variable_${variable.key}");'
                                      value="${val}">${val}</label>
                        [/#list]
                    </div>
                </td>
            </tr>
            [/#if]
        </div>
    </div>

    [/#if]

    [/#if]
    [/#list]
    [/#if]

    <br/>
    [@ww.submit
    value="Deploy ..."
    primary=true
    name='deploy'
    /]

    [/@ww.form]

    <br/>
    <h3>Most recent 50 deployments</h3>
    <br/>
    <table class="aui">
        <thead>
        <tr>
            <th scope="col">Name</th>
            <th scope="col">State</th>
            <th scope="col">Date</th>
            <th scope="col">Details</th>
        </tr>
        </thead>
        <tbody>
        [#list historyItems as item]
        <tr>
            <td>
                ${item.getDeploymentVersion().getName()} &nbsp;
            </td>
            <td>
                ${item.getDeploymentState().toString()} &nbsp;
            </td>
            <td>
                ${item.getExecutedDate().toGMTString()} &nbsp;
            </td>

            [#if item.getCustomData()??]
            <td>
                [#list item.getCustomData().keySet() as val]
                [#if !val?lower_case?contains("directory") && !val?lower_case?contains("password") &&
                !val?lower_case?contains("secret") &&
                !val?lower_case?contains("sshkey") &&
                !val?lower_case?contains("passphrase")]
                ${val} = ${item.getCustomData().get(val)} <br/>
                [/#if]
                [/#list]
                &nbsp;
            </td>
            [#else]
            <td>No further info available</td>
            [/#if]

        </tr>
        [/#list]
        </tbody>
    </table>
</div>