/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class DeploymentCache {
    private static DeploymentCache e = null;
    private static final Logger log = Logger.getLogger(DeploymentCache.class);
    ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> cache = new ConcurrentHashMap();

    private DeploymentCache() {
    }

    public static DeploymentCache getInstance() {
        if (e == null) {
            e = new DeploymentCache();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (key.toLowerCase().contains("password")) {
            return;
        }
        ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            ConcurrentLinkedQueue<String> values = this.cache.get(key);
            if (values == null) {
                values = new ConcurrentLinkedQueue();
            }
            if (!values.contains(value)) {
                values.add(value);
            }
            if (values.size() > 40) {
                values.poll();
            }
            this.cache.put(key, values);
            log.info((Object)("Added to cache " + key));
        }
    }

    public Iterator iterator(String key) {
        return this.cache.get(key).iterator();
    }

    public ConcurrentLinkedQueue<String> getValues(String s2) {
        return this.cache.get(s2);
    }
}

