/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanIdentifierImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.valens.deployments.DeploymentCache;
import com.valens.deployments.VariableElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomRunSetupForm
extends BambooActionSupport {
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final VariableDefinitionManager variableDefinitionManager;
    private final TriggerManager triggerManager;
    private final CachedPlanManager cachedPlanManager;
    private final BandanaManager bandanaManager;
    private static final Logger log = Logger.getLogger(CustomRunSetupForm.class);
    private String selectedControl;
    private String defaultValues;
    private String buildKey = "";

    @Autowired
    public CustomRunSetupForm(@ComponentImport TriggerManager triggerManager, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport CachedPlanManager cachedPlanManager) {
        this.variableDefinitionManager = variableDefinitionManager;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.triggerManager = triggerManager;
        this.bandanaManager = bandanaManager;
        this.cachedPlanManager = cachedPlanManager;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public String getSelectedControl() {
        return this.getValueAsString("com.valens.custom.deploy.selectedControl");
    }

    public String getFallbackControl() {
        return this.getValueAsString("com.valens.custom.deploy.fallbackControl");
    }

    public String getDefaultValues() {
        return this.getValueAsString("com.valens.custom.deploy.defaultValues");
    }

    public String getLists() {
        return this.getValueAsString("com.valens.custom.deploy.lists");
    }

    public PlanIdentifier getPlanIdentifier() {
        PlanIdentifierImpl p = new PlanIdentifierImpl((PlanIdentifier)this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)this.buildKey)));
        return p;
    }

    public ArrayList<String> getPossibleValues(String s2) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            for (String str : DeploymentCache.getInstance().getValues(s2)) {
                arr.add(str);
            }
        }
        catch (Exception e) {
            log.error((Object)"Found in cache ", (Throwable)e);
        }
        try {
            JSONObject obj = new JSONObject(this.getDefaultValues());
            JSONArray arr1 = obj.getJSONArray(s2);
            for (int i = 0; i < arr1.length(); ++i) {
                arr.add(arr1.getString(i));
            }
        }
        catch (JSONException e) {
            log.error((Object)"JSONException ", (Throwable)e);
        }
        for (VariableDefinition v : this.variableDefinitionManager.getPlanVariables(this.getPlanIdentifier())) {
            if (!v.getKey().toLowerCase().equalsIgnoreCase("cd_" + s2 + "_possible_values")) continue;
            try {
                JSONObject obj = new JSONObject(v.getValue());
                JSONArray arr1 = obj.getJSONArray(s2);
                for (int i = 0; i < arr1.length(); ++i) {
                    arr.add(arr1.getString(i));
                }
            }
            catch (JSONException e) {
                log.error((Object)"JSONException ", (Throwable)e);
            }
        }
        log.info((Object)("Found cache " + s2));
        return arr;
    }

    public VariableElement getTemplate(String s2) {
        VariableElement aux = new VariableElement();
        for (VariableDefinition v : this.variableDefinitionManager.getPlanVariables(this.getPlanIdentifier())) {
            if (!v.getKey().toLowerCase().equalsIgnoreCase("cd_" + s2 + "_possible_values")) continue;
            try {
                JSONObject obj = new JSONObject(v.getValue());
                JSONObject auxobj = obj.getJSONObject(s2);
                aux.setType(auxobj.getString("type"));
                try {
                    aux.setSeparator(auxobj.getString("separator"));
                }
                catch (JSONException e) {
                    aux.setSeparator(this.getLists());
                }
                ArrayList<String> vss = new ArrayList<String>();
                JSONArray arraux = auxobj.getJSONArray("values");
                for (int ii = 0; ii < arraux.length(); ++ii) {
                    vss.add(arraux.getString(ii));
                }
                aux.setValues(vss);
            }
            catch (JSONException e) {
                log.error((Object)"JSONException ", (Throwable)e);
            }
        }
        if (aux.getType() == null) {
            try {
                JSONObject obj = new JSONObject(this.getDefaultValues());
                JSONObject auxobj = obj.getJSONObject(s2);
                aux.setType(auxobj.getString("type"));
                try {
                    aux.setSeparator(auxobj.getString("separator"));
                }
                catch (JSONException e) {
                    aux.setSeparator(this.getLists());
                }
                ArrayList<String> vss = new ArrayList<String>();
                JSONArray arraux = auxobj.getJSONArray("values");
                for (int ii = 0; ii < arraux.length(); ++ii) {
                    vss.add(arraux.getString(ii));
                }
                aux.setValues(vss);
            }
            catch (JSONException e) {
                log.error((Object)"JSONException ", (Throwable)e);
            }
        }
        log.info((Object)("Found cache " + s2));
        return aux;
    }

    public boolean shouldDisplay(String s2) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.custom.deploy.mask");
        if (s2.toLowerCase().matches("cd_.*_possible_values")) {
            return false;
        }
        if (o != null && o.toString().trim().length() > 0) {
            return s2.matches(o.toString());
        }
        return true;
    }

    public List<VariableDefinition> getVariables() {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.custom.deploy.globals");
        if (this.buildKey.length() > 0) {
            ArrayList<VariableDefinition> arr = new ArrayList<VariableDefinition>();
            for (VariableDefinition v : this.variableDefinitionManager.getPlanVariables(this.getPlanIdentifier())) {
                if (!this.shouldDisplay(v.getKey())) continue;
                arr.add(v);
            }
            if (o != null && o.toString().equals("true")) {
                for (VariableDefinition v : this.variableDefinitionManager.getGlobalVariables()) {
                    if (!this.shouldDisplay(v.getKey())) continue;
                    arr.add(v);
                }
            }
            return arr;
        }
        return new ArrayList<VariableDefinition>();
    }
}

