/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.valens.conditions.ConditionEvaluatorImpl;
import com.valens.conditions.ConditionType;
import com.valens.deployments.DeploymentObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomDeploymentAction
extends BambooActionSupport {
    private final DeploymentProjectService deploymentProjectService;
    private final DeploymentResultService deploymentResultService;
    private final EnvironmentService environmentService;
    private final PluginLicenseManager licenseManager;
    private List<Environment> deploymentEnvironementList = new ArrayList<Environment>();
    private List<DeploymentProject> deploymentProjectList = new ArrayList<DeploymentProject>();
    private List<String> deploymentVersionList = new ArrayList<String>();
    private List<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
    String environmentName = "";
    String projectName = "";
    String versionName = "";
    String selectedProject = "";

    @Autowired
    public CustomDeploymentAction(@ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport EnvironmentService environmentService, @ComponentImport DeploymentResultService deploymentResultService, @ComponentImport AdministrationConfigurationAccessor configurationAccessor, @ComponentImport PluginLicenseManager licenseManager) {
        this.deploymentProjectService = deploymentProjectService;
        this.deploymentResultService = deploymentResultService;
        this.environmentService = environmentService;
        this.licenseManager = licenseManager;
    }

    public String getSelectedProject() {
        return this.selectedProject;
    }

    public void setSelectedProject(String selectedProject) {
        this.selectedProject = selectedProject;
    }

    public List<String> getDeploymentProjects() {
        ArrayList<String> deploymentObjects = new ArrayList<String>();
        deploymentObjects.add("All Projects");
        for (DeploymentProject prj : this.deploymentProjectService.getAllDeploymentProjects()) {
            deploymentObjects.add(prj.getName());
        }
        return deploymentObjects;
    }

    public List<DeploymentObject> getDeploymentObjects() {
        ArrayList<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
        for (DeploymentProject prj : this.deploymentProjectService.getAllDeploymentProjects()) {
            if (!prj.getName().equals(this.selectedProject) && !this.selectedProject.equals("All Projects")) continue;
            for (Environment env : prj.getEnvironments()) {
                deploymentObjects.add(new DeploymentObject(prj.getName(), env.getName(), prj.getId(), env.getId(), this.deploymentResultService.getLatestDeploymentResultForEnvironment(env.getId()), env.getOperations().isAllowedToExecute(), env.getOperations().isCanEdit()));
            }
        }
        return deploymentObjects;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        System.out.println(this.toString());
        this.versionName = versionName;
    }

    public String getLicensed() {
        ConditionEvaluatorImpl eval = new ConditionEvaluatorImpl(this.licenseManager);
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return "false";
        }
        return "true";
    }

    public String toString() {
        return "CustomDeploymentAction{deploymentEnvironementList=" + this.deploymentEnvironementList + ", deploymentProjectList=" + this.deploymentProjectList + ", deploymentVersionList=" + this.deploymentVersionList + ", environmentName=" + this.environmentName + ", projectName=" + this.projectName + ", versionName=" + this.versionName + '}';
    }
}

