/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.web.conditions;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plugins.web.conditions.ConditionHelper;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Optional;
import org.acegisecurity.acls.Permission;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class HasBuildCondition
implements Condition {
    private final BambooPermissionManager bambooPermissionManager;

    @Autowired
    public HasBuildCondition(@ComponentImport BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    boolean checkPlanPermission(Map<String, Object> context, Permission permission) {
        Optional<PlanKey> planKey = ConditionHelper.getPlanKey(context);
        return planKey.isPresent() && this.bambooPermissionManager.hasPlanPermission(permission, planKey.get());
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.checkPlanPermission(context, (Permission)BambooPermission.BUILD);
    }
}

