/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class GlobalConfigurePlugin
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(GlobalConfigurePlugin.class);
    private final BandanaManager bandanaManager;
    private String mask;
    private String lists;
    private String enableCache;
    private String enableGlobals;
    private String selectedControl;
    private String fallbackControl;
    private String defaultValues;
    private ArrayList<String> controlList = new ArrayList();
    private ArrayList<String> fallbackControlList = new ArrayList();

    @Autowired
    public GlobalConfigurePlugin(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.enableCache = this.enableCache;
        this.lists = this.lists;
        this.selectedControl = this.selectedControl;
        this.fallbackControl = this.fallbackControl;
        this.controlList.clear();
        this.controlList.add("Text");
        this.controlList.add("Dropdown");
        this.controlList.add("CheckBox");
        this.controlList.add("Custom");
        this.fallbackControlList.clear();
        this.fallbackControlList.add("Do not display");
        this.fallbackControlList.add("Text");
        this.fallbackControlList.add("Dropdown");
        this.fallbackControlList.add("CheckBox");
    }

    public ArrayList<String> getControlList() {
        return this.controlList;
    }

    public ArrayList<String> getFallbackControlList() {
        return this.fallbackControlList;
    }

    public void setFallbackControlList(ArrayList<String> fallbackControlList) {
        this.fallbackControlList = fallbackControlList;
    }

    public String getDefaultValues() {
        this.defaultValues = this.getValueAsString("com.valens.custom.deploy.defaultValues");
        return this.defaultValues;
    }

    public void setDefaultValues(String defaultValues) {
        this.defaultValues = defaultValues;
        this.setValue("com.valens.custom.deploy.defaultValues", this.defaultValues);
    }

    public String getFallbackControl() {
        this.fallbackControl = this.getValueAsString("com.valens.custom.deploy.fallbackControl");
        return this.fallbackControl;
    }

    public void setFallbackControl(String fallbackControl) {
        this.setValue("com.valens.custom.deploy.fallbackControl", this.fallbackControl);
        this.fallbackControl = fallbackControl;
    }

    public String getSelectedControl() {
        this.selectedControl = this.getValueAsString("com.valens.custom.deploy.selectedControl");
        return this.selectedControl;
    }

    public void setSelectedControl(String selectedControl) {
        this.selectedControl = selectedControl;
        this.setValue("com.valens.custom.deploy.selectedControl", this.selectedControl);
    }

    public String getLists() {
        this.lists = this.getValueAsString("com.valens.custom.deploy.lists");
        return this.lists;
    }

    public void setLists(String lists) {
        this.lists = lists;
        this.setValue("com.valens.custom.deploy.lists", this.lists);
    }

    public String getEnableCache() {
        this.enableCache = this.getValueAsString("com.valens.custom.deploy.cache");
        return this.enableCache;
    }

    public void setEnableCache(String enableCache) {
        this.enableCache = enableCache;
        this.setValue("com.valens.custom.deploy.cache", this.enableCache);
    }

    public String getEnableGlobals() {
        this.enableGlobals = this.getValueAsString("com.valens.custom.deploy.globals");
        return this.enableGlobals;
    }

    public void setEnableGlobals(String enableGlobals) {
        this.enableGlobals = enableGlobals;
        this.setValue("com.valens.custom.deploy.globals", this.enableGlobals);
    }

    public String getMask() {
        this.mask = this.getValueAsString("com.valens.custom.deploy.mask");
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
        this.setValue("com.valens.custom.deploy.mask", this.mask);
    }

    public String doInput() throws Exception {
        if (!super.hasGlobalAdminPermission()) {
            log.info((Object)"Currently logged in user does not have ADMIN permissions to perform this action.");
            return "error";
        }
        this.mask = this.getValueAsString("com.valens.custom.deploy.mask");
        return "success";
    }

    private void setValue(String key, Object obj) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key, obj);
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }
}

