/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.execution.triggering.DeploymentDoesNotSatisfyPrerequisitesException;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringAction;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringResult;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import com.valens.deployments.CustomEnvironmentTriggeringResultImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CustomEnvironmentTriggeringAction
implements EnvironmentTriggeringAction {
    private static final Logger log = Logger.getLogger(CustomEnvironmentTriggeringAction.class);
    private final DeploymentExecutionService deploymentExecutionService;
    private final Environment environment;
    private final DeploymentVersion version;
    private final TriggerManager triggerManager;
    private final User user;
    private HashMap<String, String> customVariables = null;

    public CustomEnvironmentTriggeringAction(DeploymentExecutionService deploymentExecutionService, TriggerManager triggerManager, Environment environment, DeploymentVersion version, User user, HashMap customVariables) {
        this.deploymentExecutionService = deploymentExecutionService;
        this.environment = environment;
        this.version = version;
        this.triggerManager = triggerManager;
        this.user = user;
        this.customVariables = customVariables;
    }

    @NotNull
    public EnvironmentTriggeringResult createDeploymentContext() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        TriggerReason triggerReason = this.triggerManager.getTriggerReason("com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason", (Map)ImmutableMap.of((Object)"ManualBuildTriggerReason.userName", (Object)this.user.getName()));
        DeploymentContext deploymentContext = null;
        try {
            deploymentContext = this.deploymentExecutionService.prepareDeploymentContext(this.environment, this.version, triggerReason);
        }
        catch (DeploymentDoesNotSatisfyPrerequisitesException e) {
            throw new RuntimeException(e);
        }
        for (String s : this.customVariables.keySet()) {
            deploymentContext.getVariableContext().addLocalVariable(s, this.customVariables.get(s));
            deploymentContext.getVariableContext().addResultVariable(s, this.customVariables.get(s));
        }
        for (String s : this.customVariables.keySet()) {
            if (!s.toLowerCase().contains("password") || this.customVariables.get(s) == null || this.customVariables.get(s).trim().length() <= 0) continue;
            deploymentContext.getCurrentResult().getCustomBuildData().put("Custom Variable " + s, this.customVariables.get(s));
        }
        return new CustomEnvironmentTriggeringResultImpl((ErrorCollection)errorCollection, deploymentContext);
    }
}

