/*
 * Decompiled with CFR 0.152.
 */
package com.valens.deployments;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringActionFactory;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.webwork.dispatcher.json.JSONArray;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.valens.deployments.DeploymentCache;
import com.valens.deployments.DeploymentObject;
import com.valens.deployments.VariableElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomDeploymentVersionAction
extends BambooActionSupport {
    private final DeploymentResultService deploymentResultService;
    private final EnvironmentService environmentService;
    private final DeploymentVersionService deploymentVersionService;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final EnvironmentTriggeringActionFactory triggeringActionFactory;
    private final DeploymentExecutionService deploymentExecutionService;
    private final VariableDefinitionManager variableDefinitionManager;
    private final TriggerManager triggerManager;
    private final BandanaManager bandanaManager;
    private List<Environment> deploymentEnvironementList = new ArrayList<Environment>();
    private List<DeploymentProject> deploymentProjectList = new ArrayList<DeploymentProject>();
    private List<String> deploymentVersionList = new ArrayList<String>();
    private static final Logger log = Logger.getLogger(CustomDeploymentVersionAction.class);
    private List<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
    private String selectedControl;
    private String defaultValues;
    private String projectName = "";
    private String environmentName = "";
    private Long projectId = 0L;
    private Long environmentId = 0L;
    private Long versionId = 0L;

    @Autowired
    public CustomDeploymentVersionAction(@ComponentImport TriggerManager triggerManager, @ComponentImport DeploymentExecutionService deploymentExecutionService, @ComponentImport EnvironmentService environmentService, @ComponentImport DeploymentVersionService deploymentVersionService, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext, @ComponentImport DeploymentResultService deploymentResultService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport EnvironmentTriggeringActionFactory triggeringActionFactory, @ComponentImport BandanaManager bandanaManager) {
        this.deploymentExecutionService = deploymentExecutionService;
        this.environmentService = environmentService;
        this.variableDefinitionManager = variableDefinitionManager;
        this.deploymentVersionService = deploymentVersionService;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.deploymentResultService = deploymentResultService;
        this.triggeringActionFactory = triggeringActionFactory;
        this.triggerManager = triggerManager;
        this.bandanaManager = bandanaManager;
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public String getSelectedControl() {
        return this.getValueAsString("com.valens.custom.deploy.selectedControl");
    }

    public String getFallbackControl() {
        return this.getValueAsString("com.valens.custom.deploy.fallbackControl");
    }

    public String getDefaultValues() {
        return this.getValueAsString("com.valens.custom.deploy.defaultValues");
    }

    public String getLists() {
        return this.getValueAsString("com.valens.custom.deploy.lists");
    }

    public ArrayList<String> getPossibleValues(String s) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            for (String str : DeploymentCache.getInstance().getValues(s)) {
                arr.add(str);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Found in cache ", (Throwable)e);
        }
        try {
            JSONObject obj = new JSONObject(this.getDefaultValues());
            JSONArray arr1 = obj.getJSONArray(s);
            for (int i = 0; i < arr1.length(); ++i) {
                arr.add(arr1.getString(i));
            }
        }
        catch (JSONException e) {
            log.debug((Object)"JSONException ", (Throwable)e);
        }
        for (VariableDefinition v : this.variableDefinitionManager.getDeploymentEnvironmentVariables(this.environmentId.longValue())) {
            if (!v.getKey().toLowerCase().equalsIgnoreCase("cd_" + s + "_possible_values")) continue;
            try {
                JSONObject obj = new JSONObject(v.getValue());
                JSONArray arr1 = obj.getJSONArray(s);
                for (int i = 0; i < arr1.length(); ++i) {
                    arr.add(arr1.getString(i));
                }
            }
            catch (JSONException e) {
                log.debug((Object)"JSONException ", (Throwable)e);
            }
        }
        log.info((Object)("Found cache " + s));
        return arr;
    }

    public VariableElement getTemplate(String s) {
        VariableElement aux = new VariableElement();
        for (VariableDefinition v : this.variableDefinitionManager.getDeploymentEnvironmentVariables(this.environmentId.longValue())) {
            if (!v.getKey().toLowerCase().equalsIgnoreCase("cd_" + s + "_possible_values")) continue;
            try {
                JSONObject obj = new JSONObject(v.getValue());
                JSONObject auxobj = obj.getJSONObject(s);
                aux.setType(auxobj.getString("type"));
                try {
                    aux.setSeparator(auxobj.getString("separator"));
                }
                catch (JSONException e) {
                    aux.setSeparator(this.getLists());
                }
                ArrayList<String> vss = new ArrayList<String>();
                JSONArray arraux = auxobj.getJSONArray("values");
                for (int ii = 0; ii < arraux.length(); ++ii) {
                    vss.add(arraux.getString(ii));
                }
                aux.setValues(vss);
            }
            catch (JSONException e) {
                log.debug((Object)"JSONException ", (Throwable)e);
            }
        }
        if (aux.getType() == null) {
            try {
                JSONObject obj = new JSONObject(this.getDefaultValues());
                JSONObject auxobj = obj.getJSONObject(s);
                aux.setType(auxobj.getString("type"));
                try {
                    aux.setSeparator(auxobj.getString("separator"));
                }
                catch (JSONException e) {
                    aux.setSeparator(this.getLists());
                }
                ArrayList<String> vss = new ArrayList<String>();
                JSONArray arraux = auxobj.getJSONArray("values");
                for (int ii = 0; ii < arraux.length(); ++ii) {
                    vss.add(arraux.getString(ii));
                }
                aux.setValues(vss);
            }
            catch (JSONException e) {
                log.debug((Object)"JSONException ", (Throwable)e);
            }
        }
        log.info((Object)("Found cache " + s));
        return aux;
    }

    public boolean shouldDisplay(String s) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.custom.deploy.mask");
        if (s.toLowerCase().matches("cd_.*_possible_values")) {
            return false;
        }
        if (o != null && o.toString().trim().length() > 0) {
            return s.matches(o.toString());
        }
        return true;
    }

    public List<VariableDefinition> getVariables() {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.custom.deploy.globals");
        if (this.environmentId > 0L) {
            ArrayList<VariableDefinition> arr = new ArrayList<VariableDefinition>();
            for (VariableDefinition v : this.variableDefinitionManager.getDeploymentEnvironmentVariables(this.environmentId.longValue())) {
                if (!this.shouldDisplay(v.getKey())) continue;
                arr.add(v);
            }
            if (o != null && o.toString().equals("true")) {
                for (VariableDefinition v : this.variableDefinitionManager.getGlobalNotOverriddenEnvironmentVariables(this.environmentId.longValue())) {
                    if (!this.shouldDisplay(v.getKey())) continue;
                    arr.add(v);
                }
            }
            return arr;
        }
        return new ArrayList<VariableDefinition>();
    }

    public List<DeploymentResult> getHistoryItems() {
        List res = this.deploymentResultService.getDeploymentResultsForEnvironment(this.environmentId.longValue(), 0, 50);
        return res;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public List<DeploymentVersion> getVersions() {
        if (this.projectId > 0L) {
            return this.deploymentVersionService.searchVersionsByName(this.projectId.longValue(), "");
        }
        return new ArrayList<DeploymentVersion>();
    }

    public String getLatestVersion() {
        if (this.projectId > 0L) {
            return this.deploymentVersionService.getLatestVersionForProject(this.projectId.longValue()).getName();
        }
        return "unknown";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnvironmentName() {
        return this.environmentService.getEnvironment(this.environmentId.longValue()).getName();
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(Long environmentId) {
        this.environmentId = environmentId;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String doExecute() throws Exception {
        return "success";
    }

    public String toString() {
        return "CustomDeploymentVersionAction{ deploymentResultService=" + this.deploymentResultService + ", environmentService=" + this.environmentService + ", deploymentEnvironementList=" + this.deploymentEnvironementList + ", deploymentProjectList=" + this.deploymentProjectList + ", deploymentVersionList=" + this.deploymentVersionList + ", deploymentObjects=" + this.deploymentObjects + ", projectName=" + this.projectName + ", environmentName=" + this.environmentName + ", projectId=" + this.projectId + ", environmentId=" + this.environmentId + '}';
    }
}

