/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.web.conditions;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.OptionalNarrow;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConditionHelper {
    public static Optional<PlanKey> getPlanKey(@NotNull Map<String, Object> context) {
        String planKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        if (StringUtils.isNotEmpty((CharSequence)planKey)) {
            try {
                return Optional.of(PlanKeys.getPlanKey((String)planKey));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static Optional<PlanResultKey> getPlanResultKey(@NotNull Map<String, Object> context) {
        String buildNumberString;
        Optional<PlanKey> planKey = ConditionHelper.getPlanKey(context);
        if (planKey.isPresent() && StringUtils.isNumeric((CharSequence)(buildNumberString = (String)context.get("buildNumber")))) {
            try {
                int buildNumber = Integer.parseInt(buildNumberString);
                return Optional.of(PlanKeys.getPlanResultKey((PlanKey)planKey.get(), (int)buildNumber));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static Optional<ResultsSummary> getResultSummary(@NotNull Map<String, Object> context) {
        return OptionalNarrow.downTo((Object)context.get("resultSummary"), ResultsSummary.class);
    }

    public static Optional<ResultsSummary> getResultSummary(@NotNull ResultsSummaryManager resultsSummaryManager, @NotNull Map<String, Object> context) {
        return ConditionHelper.getPlanResultKey(context).map(arg_0 -> ((ResultsSummaryManager)resultsSummaryManager).getResultsSummary(arg_0));
    }
}

