[#-- @ftlvariable name="action" type="com.valens.deployments.CustomDeploymentAction" --]
[#-- @ftlvariable name="" type="com.valens.deployments.CustomDeploymentAction" --]


${webResourceManager.requireResource("com.valens.deployments.bamboo-custom-deployments:custom-deployments-resources")}
[#if licensed == "true" ]
    [@ww.form id="selectProject" action="customDeploymentSetupForm" namespace="/plugins/deploy" cancelUri=cancelUrl!"" ]

    [@ww.select cssClass="selectControlType" label='Select Project' name='selectedProject' list='deploymentProjects' required='true' emptyOption='true' onchange="this.form.submit()"/]
    [@ww.textfield cssClass="textfieldControlType" label='Environment filter' name='minisearch' id="minisearch" /]

    [/@ww.form]

    <br/>


    <div class="plugin-custom-deploy-container" data-provide="plugin-custom-deploy-page" data-page="form">

    <div class="aui">

    <script type='text/javascript'>
    AJS.$(window).on('load', function() {
    var $rows = AJS.$('#envtable tr');
    AJS.$('#minisearch').keyup(function() {
        var val = AJS.$.trim(AJS.$(this).val()).replace(/ +/g, ' ').toLowerCase();

        $rows.show().filter(function() {
            var text = AJS.$(this).text().replace(/\s+/g, ' ').toLowerCase();
            return !((~text.indexOf(val) && ~text.indexOf("environment name") || ~text.indexOf("project")));
        }).hide();
    });
    });

    </script>
    </div>

    <table class="aui" id="envtable">

        <thead>
            <tr>
                <th>Environment</th>
                <th>Current state</th>                
                <th>Action</th>
            </tr>
        </thead>

        <tbody>
            [#assign project = "" /]
            [#list deploymentObjects as deployment]
            
            [#if project != "${deployment.projectId}" ]
            <tr>
                <td colspan="3">
                    <b><br>Project <a href="/deploy/viewDeploymentProjectEnvironments.action?id=${deployment.projectId}">
                        ${deployment.projectName}
                    </a></b>
                </td>
            </tr>
            [/#if]
            
            [#assign project = "${deployment.projectId}" /]
            <tr>
                [@ww.form id="executeManualDeployment_${deployment.projectId}_${deployment.environmentId}" action="customDeploymentVersion" namespace="/plugins/deploy" cancelUri=cancelUrl!"" ]
                [@ww.hidden name="environmentId" value="${deployment.environmentId}" /]
                [@ww.hidden name="projectId" value="${deployment.projectId}" /]
                <td>
                    <b>Environment name:</b> ${deployment.environmentName}
                    [#if deployment.canEdit]
                    <a title="Edit environment" href="/deploy/config/configureDeploymentProject.action?id=${deployment.projectId}&amp;environmentId=${deployment.environmentId}&amp;returnUrl=/plugins/deploy/customDeploymentSetupForm.action">
                        <span class="aui-icon aui-icon-small aui-iconfont-edit">Edit environment</span>
                    </a>
                    [/#if]
                </td>

                <td>
                    [#if deployment.lastVersion?has_content]
                    <b>State</b> ${deployment.lastVersion.deploymentState} / <b>Version</b> ${deployment.lastVersion.deploymentVersion.name}
                    [/#if]
                </td>

                <td>
                    [#if deployment.canExecute]
                        [@ww.submit
                            value="Select version ..."
                            primary=true
                            name='save'
                        /]
                    [#else]
                        &nbsp;
                    [/#if]
                </td>
                [/@ww.form]
            </tr>

            [/#list]
        </tbody>

    </table>
    [#else]
    <h1>Your license is invalid.</h1>
    [/#if]
</div>