/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.chain;

import com.valens.bamboo.chain.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializationUtils {
    public static <T extends Serializable> String serialize(T item) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(item);
            objectOutputStream.close();
            return Base64.encodeToString(byteArrayOutputStream.toByteArray(), 0);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static <T extends Serializable> T deserialize(String data) {
        try {
            byte[] dataBytes = Base64.decode(data, 0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataBytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Serializable obj = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            return (T)obj;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }
}

