/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.chain;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedBuildTaskConfigurator
extends AbstractTaskConfigurator {
    private CachedPlanManager cachedPlanManager;
    private PlanExecutionManager planExecutionManager;

    public CachedPlanManager getCachedPlanManager() {
        return this.cachedPlanManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public PlanExecutionManager getPlanExecutionManager() {
        return this.planExecutionManager;
    }

    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("custom.bamboo.plan.key", params.getString("custom.bamboo.plan.key"));
        config.put("custom.bamboo.branchName", params.getString("custom.bamboo.branchName"));
        config.put("custom.bamboo.variables", params.getString("custom.bamboo.variables"));
        config.put("custom.bamboo.revision", params.getString("custom.bamboo.revision"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (this.cachedPlanManager != null) {
            for (ImmutableTopLevelPlan p : this.cachedPlanManager.getPlans()) {
                result.put(p.getName(), p.getKey());
            }
        }
        context.put("keys", result);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (this.cachedPlanManager != null) {
            for (ImmutableTopLevelPlan p : this.cachedPlanManager.getPlans()) {
                result.put(p.getName(), p.getKey());
            }
        }
        context.put("custom.bamboo.plan.key", taskDefinition.getConfiguration().get("custom.bamboo.plan.key"));
        context.put("custom.bamboo.branchName", taskDefinition.getConfiguration().get("custom.bamboo.branchName"));
        context.put("custom.bamboo.variables", taskDefinition.getConfiguration().get("custom.bamboo.variables"));
        context.put("custom.bamboo.revision", taskDefinition.getConfiguration().get("custom.bamboo.revision"));
        context.put("keys", result);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }
}

