/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.chain;

import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.valens.bamboo.chain.TriggeringEvent;
import java.util.HashMap;
import java.util.Iterator;

public class ChainedBuildTask
implements CommonTaskType {
    EventPublisher eventPublisher;

    public EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = (EventPublisher)ContainerManager.getComponent((String)"eventPublisher");
        }
        return this.eventPublisher;
    }

    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        try {
            String key = (String)taskContext.getConfigurationMap().get((Object)"custom.bamboo.plan.key");
            String branchName = (String)taskContext.getConfigurationMap().get((Object)"custom.bamboo.branchName");
            String revision = (String)taskContext.getConfigurationMap().get((Object)"custom.bamboo.revision");
            String variables = (String)taskContext.getConfigurationMap().get((Object)"custom.bamboo.variables");
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (String g : taskContext.getCommonContext().getVariableContext().getEffectiveVariables().keySet()) {
                if (g.contains("planRepository")) continue;
                data.put(g, ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get(g)).getValue());
            }
            for (String g : taskContext.getRuntimeTaskContext().keySet()) {
                data.put(g, (String)taskContext.getRuntimeTaskContext().get(g));
            }
            data.put("displayName", taskContext.getCommonContext().getDisplayName());
            data.put("entityKey", taskContext.getCommonContext().getEntityKey().toString());
            for (String g : taskContext.getConfigurationMap().keySet()) {
                data.put(g, (String)taskContext.getConfigurationMap().get((Object)g));
            }
            if (branchName.contains(",")) {
                for (Iterator<Object> iterator : branchName.split(",")) {
                    data.put("custom.bamboo.branchName", iterator);
                    if (revision != null && revision.trim().length() > 0) {
                        data.put("custom.bamboo.revision", revision);
                    }
                    if (variables != null && variables.trim().length() > 0) {
                        data.put("custom.bamboo.variables", variables);
                    }
                    this.getEventPublisher().publish((Object)new TriggeringEvent(data));
                }
            } else {
                this.getEventPublisher().publish((Object)new TriggeringEvent(data));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }
}

