/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.chain;

import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResult;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResultBuilder;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionDataSet;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.ChangeDetectionManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainPlanTrigger
implements PlanTrigger {
    private static final Logger log = Logger.getLogger(ChainPlanTrigger.class);
    private CachedPlanManager cachedPlanManager;
    private ChangeDetectionManager changeDetectionManager;

    public CachedPlanManager getCachedPlanManager() {
        return this.cachedPlanManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public ChangeDetectionManager getChangeDetectionManager() {
        return this.changeDetectionManager;
    }

    public void setChangeDetectionManager(ChangeDetectionManager changeDetectionManager) {
        this.changeDetectionManager = changeDetectionManager;
    }

    public PlanTriggerResult triggerPlan(@NotNull TriggerReason triggerReason, @NotNull PlanResultKey planResultKey, @NotNull Map<String, String> params, @NotNull Map<String, String> customVariables, @Nullable PlanVcsRevisionDataSet lastVcsRevisionKeys) {
        PlanTriggerResultBuilder resultBuilder = PlanTriggerResultBuilder.create(customVariables);
        try {
            ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planResultKey.getPlanKey(), ImmutableChain.class);
            if (chain == null) {
                throw new IllegalStateException("Could not trigger a build with reason '" + triggerReason.getName() + "' because the plan '" + planResultKey.getPlanKey() + "' does not exist");
            }
            BuildChanges buildChanges = this.changeDetectionManager.collectAllChangesSinceLastBuild(chain, customVariables, null);
            resultBuilder.addBuildChanges(buildChanges);
        }
        catch (RepositoryException e) {
            String errorMessage = "Could not detect changes for plan '" + planResultKey + "' with trigger '" + triggerReason.getName() + "'";
            resultBuilder.addErrorMessage(errorMessage, (Exception)((Object)e));
        }
        return resultBuilder.build();
    }

    public Map<String, String> getVariablesForContinuedBuild(TriggerReason tr) {
        return new HashMap<String, String>();
    }
}

