[#-- @ftlvariable name="action" type="com.valens.bamboo.ansible.CustomDeploymentVersionAction" --]
[#-- @ftlvariable name="" type="com.valens.bamboo.ansible.CustomDeploymentVersionAction" --]

${webResourceManager.requireResource("com.valens.bamboo.ansible.bamboo-ansible-task:task-resources")}

<style>
.multicolumn {
  column-count: 4;
}
</style>


<div class="plugin-custom-deploy-container" data-provide="plugin-custom-deploy-page" data-page="form">

    <h2>Most recent 50 deployments for ${environmentName}</h2>
    <br/>
    <table class="aui">
    <thead>
        <tr>
            <th scope="col">Name</th>
            <th scope="col">State</th>
            <th scope="col">Date</th>
            <th scope="col">HOSTS</th>
            <th scope="col">TAGS</th>
            <th scope="col">EXTRA VARS</th>
            <th scope="col">OTHER FLAGS</th>
            <th scope="col">SKIPPED</th>
        </tr>
        </thead>
        <tbody>
        [#list historyItems as item]
        <tr>
            <td>
                ${item.getDeploymentVersion().getName()} &nbsp;
            </td>
            <td>
                ${item.getDeploymentState().toString()} &nbsp;
            </td>
            <td>
                ${item.getExecutedDate().toGMTString()} &nbsp;
            </td>

            [#if item.getCustomData().get("ANSIBLE_HOSTS")??]

                <td> ${item.getCustomData().get("ANSIBLE_HOSTS")} &nbsp;</td>
                <td> ${item.getCustomData().get("ANSIBLE_TAGS")} &nbsp;</td>
                <td> ${item.getCustomData().get("EXTRA_VARS")} &nbsp;</td>
                <td> ${item.getCustomData().get("ANSIBLE_OTHER")} &nbsp;</td>
                <td> ${item.getCustomData().get("SKIP_DEPLOYMENT")} &nbsp;</td>

            [#else]
                <td colspan="5">No further info available</td>
            [/#if]

        </tr>
        [/#list]
        </tbody>
    </table>
</div>