/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.valens.bamboo.ansible.conditions.ConditionEvaluator;
import com.valens.bamboo.ansible.conditions.ConditionType;
import org.apache.log4j.Logger;

public class AnsibleGlobalConfigurePlugin
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(AnsibleGlobalConfigurePlugin.class);
    private BandanaManager bandanaManager;
    private PluginLicenseManager licenseManager;
    private String forks;
    private String knownhosts;
    private String sshmux;
    private String sshopts;
    private String cypher;
    private String ansibleglobals;
    private String sedfilter;
    private String globalEnvironmentFilter;
    private String customExtraVars;

    public AnsibleGlobalConfigurePlugin(PluginLicenseManager licenseManager, BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.licenseManager = licenseManager;
    }

    public String doDefault() throws Exception {
        this.forks = this.getValueAsString("ansible.plugin.forks");
        this.ansibleglobals = this.getValueAsString("ansible.plugin.ansibleglobals");
        this.knownhosts = this.getValueAsString("ansible.plugin.knownhosts");
        this.sshmux = this.getValueAsString("ansible.plugin.sshmux");
        this.sshopts = this.getValueAsString("ansible.plugin.sshopts");
        this.cypher = this.getValueAsString("ansible.plugin.cypher");
        this.sedfilter = this.getValueAsString("ansible.plugin.sedfilter");
        this.globalEnvironmentFilter = this.getValueAsString("com.valens.ansible.environment.filter");
        this.customExtraVars = this.getValueAsString("com.valens.ansible.environment.extravars");
        return "input";
    }

    public String execute() throws Exception {
        this.setValue("ansible.plugin.ansibleglobals", this.ansibleglobals);
        this.setValue("ansible.plugin.forks", this.forks);
        this.setValue("ansible.plugin.knownhosts", this.knownhosts);
        this.setValue("ansible.plugin.sshmux", this.sshmux);
        this.setValue("ansible.plugin.sshopts", this.sshopts);
        this.setValue("ansible.plugin.cypher", this.cypher);
        this.setValue("ansible.plugin.sedfilter", this.sedfilter);
        this.setValue("com.valens.ansible.environment.filter", this.globalEnvironmentFilter);
        this.setValue("com.valens.ansible.environment.extravars", this.customExtraVars);
        return "success";
    }

    public String getCustomExtraVars() {
        return this.customExtraVars;
    }

    public void setCustomExtraVars(String customExtraVars) {
        this.customExtraVars = customExtraVars;
    }

    public String getGlobalEnvironmentFilter() {
        this.globalEnvironmentFilter = this.getValueAsString("com.valens.ansible.environment.filter");
        return this.globalEnvironmentFilter;
    }

    public void setGlobalEnvironmentFilter(String globalEnvironmentFilter) {
        this.globalEnvironmentFilter = globalEnvironmentFilter;
        this.setValue("com.valens.ansible.environment.filter", this.globalEnvironmentFilter);
    }

    private void setValue(String key, Object obj) {
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return;
        }
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key, obj);
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public String getValueAsString(String key) {
        ConditionEvaluator eval = new ConditionEvaluator(this.getLicenseManager());
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return "License not found";
        }
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            if (key.equalsIgnoreCase("ansible.plugin.sshopts")) {
                return " -o TCPKeepAlive=yes -o ServerAliveInterval=10 -o ConnectTimeout=20 -o ConnectionAttempts=3 ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.cypher")) {
                return " aes128-gcm@openssh.com,aes128-ctr ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.sedfilter")) {
                return ".*secret.*";
            }
            return "";
        }
        return (String)o;
    }

    public String getForks() {
        if (this.forks == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.forks;
    }

    public void setForks(String forks) {
        this.forks = forks;
    }

    public String getKnownhosts() {
        if (this.knownhosts == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.knownhosts;
    }

    public void setKnownhosts(String knownhosts) {
        this.knownhosts = knownhosts;
    }

    public String getSshmux() {
        if (this.sshmux == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sshmux;
    }

    public void setSshmux(String sshmux) {
        this.sshmux = sshmux;
    }

    public String getAnsibleglobals() {
        if (this.ansibleglobals == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.ansibleglobals;
    }

    public void setAnsibleglobals(String ansibleglobals) {
        this.ansibleglobals = ansibleglobals;
    }

    public String getSshopts() {
        if (this.sshopts == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sshopts;
    }

    public void setSshopts(String sshopts) {
        this.sshopts = sshopts;
    }

    public String getCypher() {
        if (this.cypher == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = cypher;
    }

    public String getSedfilter() {
        if (this.sedfilter == null) {
            try {
                this.doDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sedfilter;
    }

    public void setSedfilter(String sedfilter) {
        this.sedfilter = sedfilter;
    }
}

