/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringActionFactory;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.valens.bamboo.ansible.AnsibleVariableDefinition;
import com.valens.bamboo.ansible.AnsibleVariableDefinitionManager;
import com.valens.bamboo.ansible.DeploymentObject;
import com.valens.bamboo.ansible.VariableElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomDeploymentVersionAction
extends BambooActionSupport {
    private final DeploymentResultService deploymentResultService;
    private final EnvironmentService environmentService;
    private final DeploymentVersionService deploymentVersionService;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final EnvironmentTriggeringActionFactory triggeringActionFactory;
    private final DeploymentExecutionService deploymentExecutionService;
    private final AnsibleVariableDefinitionManager variableDefinitionManager = AnsibleVariableDefinitionManager.getInstance();
    private final TriggerManager triggerManager;
    private final BandanaManager bandanaManager;
    private List<Environment> deploymentEnvironementList = new ArrayList<Environment>();
    private List<DeploymentProject> deploymentProjectList = new ArrayList<DeploymentProject>();
    private List<String> deploymentVersionList = new ArrayList<String>();
    private static final Logger log = Logger.getLogger(CustomDeploymentVersionAction.class);
    private List<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
    private String projectName = "";
    private String environmentName = "";
    private Long projectId = 0L;
    private Long environmentId = 0L;
    private String separator = ",";
    private int maxResults = 50;
    private Long versionId = 0L;

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Autowired
    public CustomDeploymentVersionAction(@ComponentImport TriggerManager triggerManager, @ComponentImport DeploymentExecutionService deploymentExecutionService, @ComponentImport EnvironmentService environmentService, @ComponentImport DeploymentVersionService deploymentVersionService, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext, @ComponentImport DeploymentResultService deploymentResultService, @ComponentImport EnvironmentTriggeringActionFactory triggeringActionFactory, @ComponentImport BandanaManager bandanaManager) {
        this.deploymentExecutionService = deploymentExecutionService;
        this.environmentService = environmentService;
        this.deploymentVersionService = deploymentVersionService;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.deploymentResultService = deploymentResultService;
        this.triggeringActionFactory = triggeringActionFactory;
        this.triggerManager = triggerManager;
        this.bandanaManager = bandanaManager;
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public VariableElement getTemplate(String s) {
        HashSet arr;
        ArrayList<String> vss;
        VariableElement aux = new VariableElement();
        if (s.equalsIgnoreCase("ANSIBLE_HOSTS")) {
            aux.setType("checkbox");
            aux.setSeparator(this.separator);
            vss = new ArrayList<String>();
            arr = (HashSet)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.environment.hosts." + this.environmentId);
            if (arr != null) {
                vss.addAll(arr);
            }
            vss.sort(Comparator.naturalOrder());
            aux.setValues(vss);
        }
        if (s.equalsIgnoreCase("ANSIBLE_TAGS")) {
            aux.setType("checkbox");
            aux.setSeparator(this.separator);
            vss = new ArrayList();
            arr = (HashSet)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.environment.tags." + this.environmentId);
            if (arr != null) {
                vss.addAll(arr);
            }
            vss.sort(Comparator.naturalOrder());
            aux.setValues(vss);
        }
        if (s.equalsIgnoreCase("EXTRA_VARS")) {
            aux.setType("extravars");
            aux.setSeparator(" ");
            vss = new ArrayList();
            for (String str : this.getValueAsString("com.valens.ansible.environment.extravars").split(",")) {
                vss.add(str);
            }
            aux.setValues(vss);
        }
        if (s.equalsIgnoreCase("ANSIBLE_DEBUG")) {
            aux.setType("select");
            aux.setSeparator(this.separator);
            vss = new ArrayList();
            vss.add("-v");
            vss.add("-vv");
            vss.add("-vvv");
            vss.add("-vvvv");
            aux.setValues(vss);
        }
        if (s.equalsIgnoreCase("AUTO_UPDATE_HOSTS_AND_TAGS")) {
            aux.setType("select");
            aux.setSeparator(this.separator);
            vss = new ArrayList();
            vss.add("Yes");
            vss.add("No");
            aux.setValues(vss);
        }
        if (s.equalsIgnoreCase("SKIP_DEPLOYMENT")) {
            aux.setType("select");
            aux.setSeparator(this.separator);
            vss = new ArrayList();
            vss.add("No");
            vss.add("Yes");
            aux.setValues(vss);
        }
        log.info((Object)("Found cache " + s));
        return aux;
    }

    public boolean shouldDisplay(String s) {
        String o = this.getValueAsString("com.valens.ansible.deploy.mask");
        log.info((Object)("shouldDisplay " + s));
        if (o != null && o.toString().trim().length() > 0) {
            if (o.toString().trim().length() == 0) {
                return true;
            }
            return s.matches(o.toString());
        }
        return true;
    }

    public List<AnsibleVariableDefinition> getVariables() {
        if (this.environmentId > 0L) {
            ArrayList<AnsibleVariableDefinition> arr = new ArrayList<AnsibleVariableDefinition>();
            for (AnsibleVariableDefinition v : AnsibleVariableDefinitionManager.getInstance().getDeploymentEnvironmentVariables(this.environmentId)) {
                if (!this.shouldDisplay(v.getKey())) continue;
                arr.add(v);
            }
            log.info((Object)("getVariables " + arr.toString()));
            return arr;
        }
        return new ArrayList<AnsibleVariableDefinition>();
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public List<DeploymentVersion> getVersions() {
        if (this.projectId > 0L) {
            return this.deploymentVersionService.searchVersionsByName(this.projectId.longValue(), "");
        }
        return new ArrayList<DeploymentVersion>();
    }

    public List<DeploymentResult> getHistoryItems() {
        List res = this.deploymentResultService.getDeploymentResultsForEnvironment(this.environmentId.longValue(), 0, this.maxResults);
        return res;
    }

    public String getLatestVersion() {
        if (this.projectId > 0L) {
            return this.deploymentVersionService.getLatestVersionForProject(this.projectId.longValue()).getName();
        }
        return "unknown";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnvironmentName() {
        return this.environmentService.getEnvironment(this.environmentId.longValue()).getName();
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(Long environmentId) {
        this.environmentId = environmentId;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String doExecute() throws Exception {
        return "success";
    }

    public String toString() {
        return "CustomDeploymentVersionAction{ deploymentResultService=" + this.deploymentResultService + ", environmentService=" + this.environmentService + ", deploymentEnvironementList=" + this.deploymentEnvironementList + ", deploymentProjectList=" + this.deploymentProjectList + ", deploymentVersionList=" + this.deploymentVersionList + ", deploymentObjects=" + this.deploymentObjects + ", projectName=" + this.projectName + ", environmentName=" + this.environmentName + ", projectId=" + this.projectId + ", environmentId=" + this.environmentId + '}';
    }
}

