/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.valens.bamboo.ansible.AnsibleLogMutator;
import com.valens.bamboo.ansible.ProcessManagement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AnsibleTask
implements CommonTaskType {
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private BandanaManager bandanaManager;
    private ProcessManagement p;
    private static final Logger log = Logger.getLogger(String.valueOf(AnsibleTask.class));

    public AnsibleTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    public BandanaManager getBandanaManager() {
        if (this.bandanaManager == null) {
            this.bandanaManager = (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
        }
        return this.bandanaManager;
    }

    public static Logger getLog() {
        return log;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getValueAsString(String key) {
        Object o = this.getBandanaManager().getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            if (key.equalsIgnoreCase("ansible.plugin.sshopts")) {
                return " -o TCPKeepAlive=yes -o ServerAliveInterval=10 -o ConnectTimeout=20 -o ConnectionAttempts=3 ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.cypher")) {
                return " aes128-gcm@openssh.com,aes128-ctr ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.sedfilter")) {
                return ".*secret.*";
            }
            return "";
        }
        AnsibleTask.getLog().info("Bandana provided " + o);
        return (String)o;
    }

    public String getGlobalOptions() {
        String forks = this.getValueAsString("ansible.plugin.forks");
        String knownhosts = this.getValueAsString("ansible.plugin.knownhosts");
        String sshmux = this.getValueAsString("ansible.plugin.sshmux");
        String sshopts = this.getValueAsString("ansible.plugin.sshopts");
        String cypher = this.getValueAsString("ansible.plugin.cypher");
        String ansibleglobals = this.getValueAsString("ansible.plugin.ansibleglobals");
        String gopts = "";
        String gsshopts = "";
        try {
            int x = Integer.parseInt(forks);
            if (x > 0) {
                gopts = "--forks=" + forks;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (knownhosts.trim().equalsIgnoreCase("true")) {
            gsshopts = gsshopts + " -o StrictHostKeyChecking=no";
        }
        if (sshmux.trim().equalsIgnoreCase("true")) {
            gsshopts = gsshopts + " -o ControlMaster=auto -o ControlPersist=30s ";
        }
        if (!cypher.trim().equalsIgnoreCase("")) {
            gsshopts = gsshopts + " -c " + cypher;
        }
        if (!sshopts.trim().equalsIgnoreCase("")) {
            gsshopts = gsshopts + sshopts;
        }
        if (gsshopts.trim().length() > 0) {
            gopts = gopts + " " + ansibleglobals + "  -e 'ansible_ssh_args=" + gsshopts + "'";
        }
        return gopts;
    }

    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        this.p = new ProcessManagement(buildLogger);
        String sedfilter = this.getValueAsString("ansible.plugin.sedfilter");
        AnsibleLogMutator mut = new AnsibleLogMutator(sedfilter);
        taskContext.getBuildLogger().getMutatorStack().add((LogMutator)mut);
        ArrayList<String> secrets = new ArrayList<String>();
        try {
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
            String playbook = (String)taskContext.getConfigurationMap().get((Object)"playbook");
            String inventory = (String)taskContext.getConfigurationMap().get((Object)"inventory");
            String hosts = (String)taskContext.getConfigurationMap().get((Object)"hosts");
            String tags = (String)taskContext.getConfigurationMap().get((Object)"tags");
            String other = (String)taskContext.getConfigurationMap().get((Object)"other");
            String source = (String)taskContext.getConfigurationMap().get((Object)"source");
            String sshkey = (String)taskContext.getConfigurationMap().get((Object)"sshkey");
            String sshkeyfilename = (String)taskContext.getConfigurationMap().get((Object)"sshkeyfilename");
            if (sshkeyfilename == null || sshkeyfilename.trim().length() == 0) {
                sshkeyfilename = "sshkey.pem";
            }
            if (sshkey != null && sshkey.trim().length() > 0) {
                File out = new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(out, false));
                writer.write(sshkey);
                writer.close();
                out.setExecutable(false, false);
                out.setWritable(false, false);
                out.setWritable(true, true);
                out.setReadable(false, false);
                out.setReadable(true, true);
                buildLogger.addBuildLogEntry("Generating key: " + taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
                secrets.add(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
            }
            String args = "  -i " + inventory + " " + playbook + " " + hosts + " " + other + " " + this.getGlobalOptions();
            List arguments = CommandlineStringUtils.tokeniseCommandline((String)args);
            ImmutableList.Builder commandListBuilder = ImmutableList.builder();
            Capability taskCapability = this.capabilityContext.getCapabilitySet().getCapability("system.builder.ansible.ansible");
            Preconditions.checkNotNull((Object)taskCapability, (Object)"Capability system.builder.ansible.ansible is missing");
            String buildExecutable = taskCapability.getValue();
            Preconditions.checkNotNull((Object)buildExecutable, (Object)"Could not find capability, system.builder.ansible.ansible point to nowhere");
            String execAbsolutePath = new File(buildExecutable).getAbsolutePath();
            commandListBuilder.add((Object)execAbsolutePath).addAll((Iterable)arguments);
            TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
            ExternalProcess prc = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command((List)commandListBuilder.build()).env(extraEnvironmentVariables).workingDirectory(new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source)));
            taskResultBuilder.checkReturnCode(prc);
            this.p.killOrphanPids();
            TaskResult taskResult = taskResultBuilder.build();
            return taskResult;
        }
        catch (Exception e) {
            this.p.killOrphanPids();
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
        finally {
            for (String s : secrets) {
                try {
                    new File(s).delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

