[#-- @ftlvariable name="action" type="com.valens.bamboo.ansible.CustomDeploymentVersionAction" --]
[#-- @ftlvariable name="" type="com.valens.bamboo.ansible.CustomDeploymentVersionAction" --]

${webResourceManager.requireResource("com.valens.bamboo.ansible.bamboo-ansible-task:task-resources")}

<style>
.multicolumn {
  column-count: 4;
}
</style>
<script type="text/javascript">
    function OnButtonClick(nameofcontrol,stringtoput) {
        var textcontrol = document.getElementsByName(nameofcontrol)[0];
        if(textcontrol.value.trim().length > 0)
            textcontrol.value = textcontrol.value + "${separator}" + stringtoput;
        else
            textcontrol.value = stringtoput;
    }

    function ResetClick(nameofcontrol) {
        var textcontrol = document.getElementsByName(nameofcontrol)[0];

        textcontrol.value = "";
    }


    function handleClick(e, sep, nameofcontrol) {
        var el = document.getElementById(e);
        var textcontrol = document.getElementsByName(nameofcontrol)[0];
        // get reference to input elements in toppings container element
        var tops = el.getElementsByTagName('input');
        var b = 0;
        var val = "";
        // assign updateTotal function to onclick property of each checkbox
        for (var i=0, len=tops.length; i<len; i++) {
            if ( tops[i].checked ) {
                if( b == 1 )
                    val = val + sep;
                b = 1;
                val = val + tops[i].value;
            }
        }
        textcontrol.value = val;
    }

    function handleVarsClick(e, sep, nameofcontrol) {
        var el = document.getElementById(e);
        var textcontrol = document.getElementsByName(nameofcontrol)[0];
        // get reference to input elements in toppings container element
        var tops = el.getElementsByTagName('input');
        var b = 0;
        var val = "";
        // assign updateTotal function to onclick property of each checkbox
        for (var i=0, len=tops.length; i<len; i++) {
            if(tops[i].value && tops[i].value.trim().length > 0)
                val = val + tops[i].getAttribute("variable") + "=" + tops[i].value + sep;
        }
        textcontrol.value = val;
    }
</script>

<div class="aui-page-header-main"><h1>Deploy customized for <b>${environmentName}</b> (latest deployed version: ${latestVersion})</h1></div>
<br/>
<div class="plugin-custom-deploy-container" data-provide="plugin-custom-deploy-page" data-page="form">

    [@ww.form id="selectVersion" action="/plugins/servlet/deploy/ansibledeploystart" namespace="/plugins/servlet/ansibledeploy" cancelUri=cancelUrl!""  ]

    [@ww.hidden name="projectId" value="${projectId}" /]
    [@ww.hidden name="environmentId" value="${environmentId}" /]
    [@ww.select cssClass="full-width-field" rows="30" toggle='true' value="selectedPrimary" label="Choose a version:" listKey="id" listValue="name" name="versionId" list="versions"/]

    <table class="aui">

        <thead>
            <tr>
                <th width="25%">Variable Name</th>
                <th>Value</th>                
            </tr>
        </thead>

        <tbody>

                [#list variables as variable]
                 [#if action.getTemplate(variable.key).getType()??]
                    [#if action.getTemplate(variable.key).getType()?lower_case?contains("select")]
                    <tr>
                      <td>${variable.key}</td>
                      <td >
                        <select name="variable_${variable.key}" class="text long-field" >
                                [#list action.getTemplate(variable.key).getValues() as val]
                                    <option value="${val}">${val}</option>
                                [/#list]
                        </select>
                       </td>
                     </tr>
                    [/#if]

                    [#if action.getTemplate(variable.key).getType()?lower_case?contains("checkbox")]
                        <tr>
                            <td>${variable.key}</td>

                            <td>
                                <section>
                                   <article>
                                        <details>
                                            <summary>...</summary>
                                            <input name="variable_${variable.key}" class="text full-width-field" readonly="readonly" type="text" value="${variable.value}"/>
                                            <div id="element_${variable.key}" class="multicolumn">
                                            [#list action.getTemplate( variable.key ).getValues() as val]
                                                <p>
                                                <label><input type='checkbox' class="aui" onclick='handleClick("element_${variable.key}","${action.getTemplate( variable.key ).getSeparator()}","variable_${variable.key}");' value="${val}" >${val}</label>
                                                </p>
                                            [/#list]
                                            </div>
                                     </details>
                                   </article>
                                </section>
                            </td>
                        </tr>
                    [/#if]

                    [#if action.getTemplate(variable.key).getType()?lower_case?contains("extravars")]
                        <tr>
                            <td>${variable.key}</td>
                            <td>
                                <section>
                                   <article>
                                        <details>
                                            <summary>...</summary>
                                            <input name="variable_${variable.key}" readonly="readonly" class="text full-width-field" type="text"/>
                                            <div id="element_${variable.key}" style="column-count: 1;">
                                            <table class="aui">

                                            [#list  action.getTemplate( variable.key ).getValues() as val]
                                                <tr>

                                                <td width="30%">${val}</td>
                                                <td><input type='text' variable="${val}" class="text long-field" onchange='handleVarsClick("element_${variable.key}","  ","variable_${variable.key}");' ></td>

                                                </tr>
                                            [/#list]
                                            </div>
                                            </table>
                                        </details>
                                   </article>
                                </section>
                             </td>
                        </tr>
                    [/#if]

                    [#if action.getTemplate(variable.key).getType()?lower_case?contains("text")]
                        <tr>
                            <td>${variable.key}</td>
                            [#if variable.key?lower_case?contains("password")]
                                <td><input name="variable_${variable.key}" class="text long-field" type="password" value="${variable.value}"/></td>
                            [#else]
                                <td><input name="variable_${variable.key}" class="text long-field" type="text" value="${variable.value}"/></td>
                            [/#if]
                        </tr>
                        [#if variable.key?lower_case?contains("password")]
                        <p></p>
                        [#else]
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input type="button" class="button aui" id="reset${val}" onclick="ResetClick('variable_${variable.key}')" value="Reset" />
                                [#list  action.getTemplate( variable.key ).getValues() as val]
                                    <input type="button" class="button aui" id="btnsubmit${val}" onclick="OnButtonClick('variable_${variable.key}','${val}')" value="${val}" />
                                [/#list]
                            </td>
                        </tr>
						[/#if]
                    [/#if]
                 [/#if]
                 [/#list]

        </tbody>
    </table>
    <br/>
    SKIP_DEPLOYMENT will allow you to update the HOST and TAGs configuration.<br/>
    EXTRA_VARS configuration is global and is allowing DEVOPS teams to control what can be safely customized in a deployment.
    <br/><br/>
    [@ww.submit
    value="Deploy ..."
    primary=true
    name='deploy'
    /]

    [/@ww.form]

    <br/>
    <h2>Most recent 50 deployments</h2>
    <br/>
    <table class="aui">
        <thead>
            <tr>
                <th scope="col">Name</th>
                <th scope="col">State</th>
                <th scope="col">Date</th>
                <th scope="col">HOSTS</th>
                <th scope="col">TAGS</th>
                <th scope="col">EXTRA VARS</th>
                <th scope="col">OTHER FLAGS</th>
                <th scope="col">SKIPPED</th>
            </tr>
            </thead>
            <tbody>
            [#list historyItems as item]
            <tr>
                <td>
                    ${item.getDeploymentVersion().getName()} &nbsp;
                </td>
                <td>
                    ${item.getDeploymentState().toString()} &nbsp;
                </td>
                <td>
                    ${item.getExecutedDate().toGMTString()} &nbsp;
                </td>

                [#if item.getCustomData().get("ANSIBLE_HOSTS")??]

                    <td> ${item.getCustomData().get("ANSIBLE_HOSTS")} &nbsp;</td>
                    <td> ${item.getCustomData().get("ANSIBLE_TAGS")} &nbsp;</td>
                    <td> ${item.getCustomData().get("EXTRA_VARS")} &nbsp;</td>
                    <td> ${item.getCustomData().get("ANSIBLE_OTHER")} &nbsp;</td>
                    <td> ${item.getCustomData().get("SKIP_DEPLOYMENT")} &nbsp;</td>

                [#else]
                    <td colspan="5">No further info available</td>
                [/#if]

            </tr>
            [/#list]
            </tbody>
        </table>
</div>