/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.valens.bamboo.ansible.AnsibleLogMutator;
import com.valens.bamboo.ansible.ProcessManagement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AnsiblePlaybookTask
implements CommonTaskType {
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private BandanaManager bandanaManager;
    private ProcessManagement p;
    private static final Logger log = Logger.getLogger(String.valueOf(AnsiblePlaybookTask.class));

    public static Logger getLog() {
        return log;
    }

    public AnsiblePlaybookTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    public BandanaManager getBandanaManager() {
        if (this.bandanaManager == null) {
            this.bandanaManager = (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
        }
        return this.bandanaManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getValueAsString(String key) {
        Object o = this.getBandanaManager().getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            if (key.equalsIgnoreCase("ansible.plugin.sshopts")) {
                return " -o TCPKeepAlive=yes -o ServerAliveInterval=10 -o ConnectTimeout=20 -o ConnectionAttempts=3 ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.cypher")) {
                return " aes128-gcm@openssh.com,aes128-ctr ";
            }
            if (key.equalsIgnoreCase("ansible.plugin.sedfilter")) {
                return ".*secret.*";
            }
            return "";
        }
        AnsiblePlaybookTask.getLog().info("Bandana provided " + o);
        return (String)o;
    }

    public String getGlobalOptions() {
        String forks = this.getValueAsString("ansible.plugin.forks");
        String knownhosts = this.getValueAsString("ansible.plugin.knownhosts");
        String sshmux = this.getValueAsString("ansible.plugin.sshmux");
        String sshopts = this.getValueAsString("ansible.plugin.sshopts");
        String cypher = this.getValueAsString("ansible.plugin.cypher");
        String ansibleglobals = this.getValueAsString("ansible.plugin.ansibleglobals");
        String gopts = "";
        String gsshopts = "";
        try {
            int x = Integer.parseInt(forks);
            if (x > 0) {
                gopts = "--forks=" + forks;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (knownhosts.trim().equalsIgnoreCase("true")) {
            gsshopts = gsshopts + " -o StrictHostKeyChecking=no";
        }
        if (sshmux.trim().equalsIgnoreCase("true")) {
            gsshopts = gsshopts + " -o ControlMaster=auto -o ControlPersist=30s ";
        }
        if (!cypher.trim().equalsIgnoreCase("")) {
            gsshopts = gsshopts + " -c " + cypher;
        }
        if (!sshopts.trim().equalsIgnoreCase("")) {
            gsshopts = gsshopts + sshopts;
        }
        if (gsshopts.trim().length() > 0) {
            gopts = gopts + " " + ansibleglobals + "  -e \"'ansible_ssh_args=" + gsshopts.trim() + "'\"";
        }
        return gopts;
    }

    private void logMap(BuildLogger buildLogger, String ss, Map<String, String> m) {
        buildLogger.addBuildLogEntry(ss);
        for (String s : m.keySet()) {
            buildLogger.addBuildLogEntry("MAP: " + s + " = " + m.get(s));
        }
    }

    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        this.p = new ProcessManagement(buildLogger);
        ArrayList<String> secrets = new ArrayList<String>();
        String sedfilter = this.getValueAsString("ansible.plugin.sedfilter");
        AnsibleLogMutator mut = new AnsibleLogMutator(sedfilter);
        taskContext.getBuildLogger().getMutatorStack().add((LogMutator)mut);
        try {
            OutputStreamWriter writer;
            File out;
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"), false);
            String playbook = (String)taskContext.getConfigurationMap().get((Object)"playbook");
            String inventory = (String)taskContext.getConfigurationMap().get((Object)"inventory");
            String playbookarea = (String)taskContext.getConfigurationMap().get((Object)"playbookarea");
            String multipleinventories = (String)taskContext.getConfigurationMap().get((Object)"multipleinventories");
            String inventoryarea = (String)taskContext.getConfigurationMap().get((Object)"inventoryarea");
            String hosts = (String)taskContext.getConfigurationMap().get((Object)"hosts");
            String tags = (String)taskContext.getConfigurationMap().get((Object)"tags");
            String other = (String)taskContext.getConfigurationMap().get((Object)"other");
            String source = (String)taskContext.getConfigurationMap().get((Object)"source");
            String sshkey = (String)taskContext.getConfigurationMap().get((Object)"sshkey");
            String sshkeyfilename = (String)taskContext.getConfigurationMap().get((Object)"sshkeyfilename");
            String vaultpass = (String)taskContext.getConfigurationMap().get((Object)"vaultpass");
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("ANSIBLE_DEBUG") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_DEBUG")).getValue().trim().length() > 0) {
                other = other + " " + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_DEBUG")).getValue();
            }
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("ANSIBLE_HOSTS") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_HOSTS")).getValue().trim().length() > 0) {
                if (hosts.trim().length() > 0) {
                    hosts = hosts + ",";
                }
                hosts = hosts + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_HOSTS")).getValue();
            }
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("ANSIBLE_TAGS") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_TAGS")).getValue().trim().length() > 0) {
                if (tags.trim().length() > 0) {
                    tags = tags + ",";
                }
                tags = tags + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("ANSIBLE_TAGS")).getValue();
            }
            if (playbookarea != null && playbookarea.trim().length() > 0) {
                File out2 = new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + "playbookarea.yml");
                OutputStreamWriter writer2 = new OutputStreamWriter(new FileOutputStream(out2, false));
                writer2.write(playbookarea);
                playbook = "playbookarea.yml";
                writer2.close();
            }
            String secondinventory = "";
            if (inventoryarea != null && inventoryarea.trim().length() > 0) {
                out = new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + "inventoryarea.yml");
                writer = new OutputStreamWriter(new FileOutputStream(out, false));
                writer.write(inventoryarea);
                secondinventory = "inventoryarea.yml";
                writer.close();
            }
            if (sshkeyfilename == null || sshkeyfilename.trim().length() == 0) {
                sshkeyfilename = "sshkey.pem";
            }
            if (sshkey != null && sshkey.trim().length() > 0) {
                out = new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
                writer = new OutputStreamWriter(new FileOutputStream(out, false));
                writer.write(sshkey);
                writer.close();
                out.setExecutable(false, false);
                out.setWritable(false, false);
                out.setWritable(true, true);
                out.setReadable(false, false);
                out.setReadable(true, true);
                buildLogger.addBuildLogEntry("Generating key: " + taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
                secrets.add(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + sshkeyfilename);
            }
            if (vaultpass != null && vaultpass.trim().length() > 0) {
                out = new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + ".vault-password-file");
                writer = new OutputStreamWriter(new FileOutputStream(out, false));
                writer.write(vaultpass);
                writer.close();
                out.setExecutable(false, false);
                out.setWritable(false, false);
                out.setWritable(true, true);
                out.setReadable(false, false);
                out.setReadable(true, true);
                buildLogger.addBuildLogEntry("Generating vault password file: " + taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + ".vault-password-file");
                secrets.add(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + ".vault-password-file");
            }
            String args = " ";
            boolean state = true;
            if (multipleinventories == null || multipleinventories == "" || multipleinventories.equalsIgnoreCase("false")) {
                state = false;
            }
            if (!state) {
                args = secondinventory.length() > 0 ? args + " -i " + secondinventory + " " : args + " -i " + inventory + " ";
            } else {
                if (secondinventory.length() > 0) {
                    args = args + " -i " + secondinventory + " ";
                }
                if (inventory.length() > 0) {
                    args = args + " -i " + inventory + " ";
                }
            }
            String argsTags = args + playbook + " --limit=all " + (vaultpass != null && vaultpass.length() > 0 ? "--vault-password-file=" + taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + ".vault-password-file" : "") + " " + other + " " + this.getGlobalOptions();
            List argumentsTags = CommandlineStringUtils.tokeniseCommandline((String)argsTags);
            args = args + playbook + " " + (hosts != null && hosts.length() > 0 ? "--limit=" + hosts : "") + " " + (tags != null && tags.length() > 0 ? "--tags=" + tags : "") + " " + (vaultpass != null && vaultpass.length() > 0 ? "--vault-password-file=" + taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source + File.separator + ".vault-password-file" : "") + " " + other + " " + this.getGlobalOptions();
            List arguments = CommandlineStringUtils.tokeniseCommandline((String)args);
            buildLogger.addBuildLogEntry("Arguments: " + arguments.toString());
            ImmutableList.Builder commandListBuilder = ImmutableList.builder();
            ImmutableList.Builder tagsCommandListBuilder = ImmutableList.builder();
            Capability taskCapability = this.capabilityContext.getCapabilitySet().getCapability("system.builder.ansible-playbook.ansible-playbook");
            Preconditions.checkNotNull((Object)taskCapability, (Object)"Capability system.builder.ansible-playbook.ansible-playbook is missing");
            String buildExecutable = taskCapability.getValue();
            Preconditions.checkNotNull((Object)buildExecutable, (Object)"Could not find capability, system.builder.ansible-playbook.ansible-playbook point to nowhere");
            String execAbsolutePath = new File(buildExecutable).getAbsolutePath();
            commandListBuilder.add((Object)execAbsolutePath).addAll((Iterable)arguments);
            tagsCommandListBuilder.add((Object)execAbsolutePath).addAll((Iterable)argumentsTags);
            tagsCommandListBuilder.add((Object)"--list-tags");
            tagsCommandListBuilder.add((Object)"--list-hosts");
            taskContext.getCommonContext().getCurrentResult().getCustomBuildData().put("ANSIBLE_HOSTS", hosts);
            taskContext.getCommonContext().getCurrentResult().getCustomBuildData().put("ANSIBLE_TAGS", tags);
            taskContext.getCommonContext().getCurrentResult().getCustomBuildData().put("ANSIBLE_OTHER", other);
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("EXTRA_VARS") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("EXTRA_VARS")).getValue().trim().length() > 0) {
                commandListBuilder.add((Object)("\"--extra-vars=" + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("EXTRA_VARS")).getValue() + "\""));
                tagsCommandListBuilder.add((Object)("\"--extra-vars=" + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("EXTRA_VARS")).getValue() + "\""));
                taskContext.getCommonContext().getCurrentResult().getCustomBuildData().put("EXTRA_VARS", ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("EXTRA_VARS")).getValue());
            }
            TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("AUTO_UPDATE_HOSTS_AND_TAGS") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("AUTO_UPDATE_HOSTS_AND_TAGS")).getValue().equalsIgnoreCase("YES")) {
                ExternalProcess externalProcess = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command((List)tagsCommandListBuilder.build()).env(extraEnvironmentVariables).workingDirectory(new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source)));
            }
            if (!taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("SKIP_DEPLOYMENT") || taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("SKIP_DEPLOYMENT") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("SKIP_DEPLOYMENT")).getValue().equalsIgnoreCase("NO")) {
                ExternalProcess prc = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command((List)commandListBuilder.build()).env(extraEnvironmentVariables).workingDirectory(new File(taskContext.getWorkingDirectory().getAbsolutePath() + File.separator + source)));
                taskResultBuilder.checkReturnCode(prc);
            } else {
                taskResultBuilder.success();
                taskContext.getCommonContext().getCurrentResult().getCustomBuildData().put("SKIP_DEPLOYMENT", "YES");
            }
            if (taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("AUTO_UPDATE_HOSTS_AND_TAGS") && taskContext.getCommonContext().getVariableContext().getEffectiveVariables().containsKey("custom_deployment_environment_id") && ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("AUTO_UPDATE_HOSTS_AND_TAGS")).getValue().equalsIgnoreCase("YES")) {
                buildLogger.addBuildLogEntry("Found hosts: " + mut.getHosts());
                buildLogger.addBuildLogEntry("Found tags: " + mut.getTags());
                this.getBandanaManager().setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.environment.hosts." + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("custom_deployment_environment_id")).getValue(), mut.getHosts());
                this.getBandanaManager().setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.environment.tags." + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("custom_deployment_environment_id")).getValue(), mut.getTags());
                buildLogger.addBuildLogEntry("Saved tags: com.valens.environment.tags." + ((VariableDefinitionContext)taskContext.getCommonContext().getVariableContext().getEffectiveVariables().get("custom_deployment_environment_id")).getValue());
            }
            this.p.killOrphanPids();
            TaskResult t = taskResultBuilder.build();
            this.logMap(buildLogger, "getResultData", t.getResultData());
            TaskResult taskResult = t;
            return taskResult;
        }
        catch (Exception e) {
            this.p.killOrphanPids();
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
        finally {
            for (String s : secrets) {
                try {
                    new File(s).delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

