/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringAction;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringActionFactory;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.valens.bamboo.ansible.CustomEnvironmentTriggeringAction;
import com.valens.bamboo.ansible.DeploymentObject;
import com.valens.bamboo.ansible.conditions.ConditionEvaluator;
import com.valens.bamboo.ansible.conditions.ConditionType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomDeploymentServlet
extends HttpServlet {
    private final DeploymentResultService deploymentResultService;
    private final EnvironmentService environmentService;
    private final DeploymentVersionService deploymentVersionService;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final EnvironmentTriggeringActionFactory triggeringActionFactory;
    private final DeploymentExecutionService deploymentExecutionService;
    private final VariableDefinitionManager variableDefinitionManager;
    private final TriggerManager triggerManager;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseManager licenseManager;
    private final BandanaManager bandanaManager;
    private List<Environment> deploymentEnvironementList = new ArrayList<Environment>();
    private List<DeploymentProject> deploymentProjectList = new ArrayList<DeploymentProject>();
    private List<String> deploymentVersionList = new ArrayList<String>();
    private List<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
    private String projectName = "";
    private String environmentName = "";
    private Long projectId = 0L;
    private Long environmentId = 0L;
    private Long versionId = 0L;

    @Autowired
    public CustomDeploymentServlet(@ComponentImport BandanaManager bandanaManager, @ComponentImport TriggerManager triggerManager, @ComponentImport DeploymentExecutionService deploymentExecutionService, @ComponentImport EnvironmentService environmentService, @ComponentImport DeploymentVersionService deploymentVersionService, @ComponentImport BambooAuthenticationContext bambooAuthenticationContext, @ComponentImport DeploymentResultService deploymentResultService, @ComponentImport VariableDefinitionManager variableDefinitionManager, @ComponentImport EnvironmentTriggeringActionFactory triggeringActionFactory, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PluginLicenseManager licenseManager) {
        this.deploymentExecutionService = deploymentExecutionService;
        this.environmentService = environmentService;
        this.bandanaManager = bandanaManager;
        this.variableDefinitionManager = variableDefinitionManager;
        this.deploymentVersionService = deploymentVersionService;
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.deploymentResultService = deploymentResultService;
        this.triggeringActionFactory = triggeringActionFactory;
        this.triggerManager = triggerManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.licenseManager = licenseManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public boolean getLicense() {
        ConditionEvaluator eval = new ConditionEvaluator(this.licenseManager);
        return eval.evaluate(ConditionType.LICENSED);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = this.getUserManager().getRemoteUsername(request);
        HashMap<String, String> variables = new HashMap<String, String>();
        User user = this.bambooAuthenticationContext.getUser();
        if (username == null) {
            this.redirectToLogin(request, response);
            return;
        }
        ConditionEvaluator eval = new ConditionEvaluator(this.licenseManager);
        if (!eval.evaluate(ConditionType.LICENSED)) {
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().append("Your license for Custom Deployments is invalid or expired !");
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        variables.put("custom_deployment_environment_id", request.getParameter("environmentId"));
        for (String s : request.getParameterMap().keySet()) {
            if (!s.startsWith("variable_")) continue;
            variables.put(s.replaceAll("variable_", ""), request.getParameter(s));
        }
        try {
            Environment env = this.environmentService.getEnvironment(Long.parseLong(request.getParameter("environmentId")));
            DeploymentVersion version = this.deploymentVersionService.getDeploymentVersion(Long.parseLong(request.getParameter("versionId")));
            CustomEnvironmentTriggeringAction environmentTriggeringAction = new CustomEnvironmentTriggeringAction(this.deploymentExecutionService, this.triggerManager, env, version, user, variables);
            if (this.deploymentExecutionService.isEnvironmentBeingDeployedTo(env.getId())) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().append("The environment is busy and cannot be deployed.");
                response.sendError(503, "The environment is busy and cannot be deployed.");
                return;
            }
            if (!env.getOperations().isAllowedToExecute()) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().append("You don't have the required permissions to deploy");
                response.sendError(403, "You don't have the required permissions to deploy");
                return;
            }
            if (!this.deploymentExecutionService.isEnvironmentBeingDeployedTo(env.getId()) && env.getOperations().isAllowedToExecute() && env.getOperations().isCanExecute()) {
                ExecutionRequestResult executionRequestResult = this.deploymentExecutionService.execute(env, (EnvironmentTriggeringAction)environmentTriggeringAction);
                if (executionRequestResult.getDeploymentResultId() != null) {
                    this.sendDeployRedirect(request, response, executionRequestResult.getDeploymentResultId());
                }
            } else {
                this.sendEnvironmentRedirect(request, response, env.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    public void sendDeployRedirect(HttpServletRequest request, HttpServletResponse response, long id) throws IOException {
        response.sendRedirect(request.getContextPath() + "/deploy/viewDeploymentResult.action?deploymentResultId=" + id);
    }

    public void sendEnvironmentRedirect(HttpServletRequest request, HttpServletResponse response, long id) throws IOException {
        response.sendRedirect(request.getContextPath() + "/deploy/viewEnvironment.action?id=" + id);
    }

    public URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public String getLists() {
        return ",";
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }
}

