/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.valens.bamboo.ansible.DeploymentObject;
import com.valens.bamboo.ansible.conditions.ConditionEvaluator;
import com.valens.bamboo.ansible.conditions.ConditionType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CustomDeploymentAction
extends BambooActionSupport {
    private final DeploymentProjectService deploymentProjectService;
    private final DeploymentResultService deploymentResultService;
    private final EnvironmentService environmentService;
    private final PluginLicenseManager licenseManager;
    private final BandanaManager bandanaManager;
    private List<Environment> deploymentEnvironementList = new ArrayList<Environment>();
    private List<DeploymentProject> deploymentProjectList = new ArrayList<DeploymentProject>();
    private List<String> deploymentVersionList = new ArrayList<String>();
    private List<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
    String environmentName = "";
    String projectName = "";
    String versionName = "";
    String selectedProject = "";

    @Autowired
    public CustomDeploymentAction(@ComponentImport DeploymentProjectService deploymentProjectService, @ComponentImport EnvironmentService environmentService, @ComponentImport DeploymentResultService deploymentResultService, @ComponentImport AdministrationConfigurationAccessor configurationAccessor, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport BandanaManager bandanaManager) {
        this.deploymentProjectService = deploymentProjectService;
        this.deploymentResultService = deploymentResultService;
        this.environmentService = environmentService;
        this.licenseManager = licenseManager;
        this.bandanaManager = bandanaManager;
    }

    public String getValueAsString(String key) {
        Object o = this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    public String getSelectedProject() {
        return this.selectedProject;
    }

    public void setSelectedProject(String selectedProject) {
        this.selectedProject = selectedProject;
    }

    public List<String> getDeploymentProjects() {
        ArrayList<String> deploymentObjects = new ArrayList<String>();
        deploymentObjects.add("All Projects");
        for (DeploymentProject prj : this.deploymentProjectService.getAllDeploymentProjects()) {
            deploymentObjects.add(prj.getName());
        }
        return deploymentObjects;
    }

    public List<DeploymentObject> getDeploymentObjects() {
        ArrayList<DeploymentObject> deploymentObjects = new ArrayList<DeploymentObject>();
        String filter = (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "com.valens.ansible.environment.filter");
        for (DeploymentProject prj : this.deploymentProjectService.getAllDeploymentProjects()) {
            if (!prj.getName().equals(this.selectedProject) && !this.selectedProject.equals("All Projects")) continue;
            for (Environment env : prj.getEnvironments()) {
                if ((filter == null || !env.getName().matches(filter)) && filter != null && filter.trim().length() != 0) continue;
                deploymentObjects.add(new DeploymentObject(prj.getName(), env.getName(), prj.getId(), env.getId(), this.deploymentResultService.getLatestDeploymentResultForEnvironment(env.getId()), env.getOperations().isAllowedToExecute(), env.getOperations().isCanEdit()));
            }
        }
        return deploymentObjects;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        System.out.println(this.toString());
        this.versionName = versionName;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String getLicensed() {
        ConditionEvaluator eval = new ConditionEvaluator(this.licenseManager);
        if (!eval.evaluate(ConditionType.LICENSED)) {
            return "false";
        }
        return "true";
    }

    public String toString() {
        return "CustomDeploymentAction{deploymentEnvironementList=" + this.deploymentEnvironementList + ", deploymentProjectList=" + this.deploymentProjectList + ", deploymentVersionList=" + this.deploymentVersionList + ", environmentName=" + this.environmentName + ", projectName=" + this.projectName + ", versionName=" + this.versionName + '}';
    }
}

