/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.collect.ImmutableSet;
import com.valens.bamboo.ansible.AnsiblePlaybookTaskConfigurator;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsibleTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport {
    private static final Logger log = Logger.getLogger(AnsiblePlaybookTaskConfigurator.class);

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("playbook", params.getString("playbook"));
        config.put("inventory", params.getString("inventory"));
        config.put("hosts", params.getString("hosts"));
        config.put("tags", params.getString("tags"));
        config.put("other", params.getString("other"));
        config.put("source", params.getString("source"));
        String paramKey = params.getString("sshkey");
        String tmpKey = this.readPrivateKey(params);
        if (tmpKey != null) {
            paramKey = tmpKey;
        }
        if (previousTaskDefinition == null || paramKey != null && paramKey.trim().length() > 0) {
            config.put("sshkey", paramKey);
        } else if (previousTaskDefinition != null) {
            config.put("sshkey", (String)previousTaskDefinition.getConfiguration().get("sshkey"));
        }
        config.put("sshkeyfilename", params.getString("sshkeyfilename"));
        return config;
    }

    private String readPrivateKey(ActionParametersMap params) {
        File private_key_file = (File)params.getFiles().get("private_key");
        if (private_key_file != null) {
            try {
                String key = FileUtils.readFileToString((File)private_key_file);
                return key;
            }
            catch (IOException e) {
                log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
            }
        } else {
            log.error((Object)"Unable to load key from config submission!");
        }
        return null;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("playbook", "main.yml");
        context.put("inventory", "inventories/development");
        context.put("hosts", "all");
        context.put("tags", "");
        context.put("other", "");
        context.put("source", "");
        context.put("sshkey", "");
        context.put("sshkeyfilename", "");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("playbook", taskDefinition.getConfiguration().get("playbook"));
        context.put("inventory", taskDefinition.getConfiguration().get("inventory"));
        context.put("hosts", taskDefinition.getConfiguration().get("hosts"));
        context.put("tags", taskDefinition.getConfiguration().get("tags"));
        context.put("other", taskDefinition.getConfiguration().get("other"));
        context.put("source", taskDefinition.getConfiguration().get("source"));
        context.put("sshkeyfilename", taskDefinition.getConfiguration().get("sshkeyfilename"));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("playbook", taskDefinition.getConfiguration().get("playbook"));
        context.put("inventory", taskDefinition.getConfiguration().get("inventory"));
        context.put("hosts", taskDefinition.getConfiguration().get("hosts"));
        context.put("tags", taskDefinition.getConfiguration().get("tags"));
        context.put("other", taskDefinition.getConfiguration().get("other"));
        context.put("source", taskDefinition.getConfiguration().get("source"));
        context.put("sshkeyfilename", taskDefinition.getConfiguration().get("sshkeyfilename"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }

    public Set<Requirement> calculateRequirements(TaskDefinition td) {
        return ImmutableSet.of((Object)new RequirementImpl("system.builder.ansible.ansible", true, ".*"));
    }
}

