/*
 * Decompiled with CFR 0.152.
 */
package com.valens.bamboo.ansible;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogMutator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AnsibleLogMutator
implements LogMutator {
    private final String regexp;
    Set<String> hosts;
    Set<String> tags;
    Pattern pTags = Pattern.compile(".* TAGS: \\[(.*)\\]$");
    Pattern pHosts = Pattern.compile("^ +pattern: \\[u'(.*)'\\]");

    public Set<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Set<String> hosts) {
        this.hosts = hosts;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public AnsibleLogMutator(String regexp) {
        this.hosts = new HashSet<String>();
        this.tags = new HashSet<String>();
        this.regexp = regexp;
    }

    public LogEntry mutate(@NotNull LogEntry logEntry) {
        return this.createMutatedLog(logEntry);
    }

    public LogEntry mutateError(@NotNull LogEntry logEntry) {
        return this.createMutatedLog(logEntry);
    }

    private LogEntry createMutatedLog(LogEntry originalLogEntry) {
        String modifiedLog;
        Matcher m = this.pTags.matcher(originalLogEntry.getUnstyledLog());
        if (m.find()) {
            for (String s : m.group(1).split(",")) {
                if (s.trim().length() <= 0) continue;
                this.tags.add(s.trim());
            }
        }
        if ((m = this.pHosts.matcher(originalLogEntry.getUnstyledLog())).find()) {
            for (String s : m.group(1).split(":")) {
                if (s.trim().length() <= 0) continue;
                this.hosts.add(s.trim());
            }
        }
        try {
            modifiedLog = originalLogEntry.getUnstyledLog().replaceAll(this.regexp, "***MASKED***");
        }
        catch (Exception e) {
            return originalLogEntry.cloneAndMutate("Global REGEXP is invalid");
        }
        return originalLogEntry.cloneAndMutate(modifiedLog);
    }
}

