/*
 * Decompiled with CFR 0.152.
 */
package org.valens;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogScannerTaskConfigurator
extends AbstractTaskConfigurator
implements TaskTestResultsSupport {
    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("errormask", params.getString("errormask"));
        config.put("nonerrormask", params.getString("nonerrormask"));
        config.put("filemask", params.getString("filemask"));
        config.put("linemask", params.getString("linemask"));
        config.put("extension", params.getString("extension"));
        config.put("linesplittermask", params.getString("linesplittermask"));
        config.put("tokennumber", params.getString("tokennumber"));
        config.put("filefound", params.getString("filefound"));
        config.put("testsuite", params.getString("testsuite"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("errormask", "^fail:.*");
        context.put("nonerrormask", "^ok.*");
        context.put("filemask", "*.*");
        context.put("linemask", ".*");
        context.put("extension", "log");
        context.put("linesplittermask", ",");
        context.put("tokennumber", "2");
        context.put("filefound", "true");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("errormask", taskDefinition.getConfiguration().get("errormask"));
        context.put("nonerrormask", taskDefinition.getConfiguration().get("nonerrormask"));
        context.put("filemask", taskDefinition.getConfiguration().get("filemask"));
        context.put("linemask", taskDefinition.getConfiguration().get("linemask"));
        context.put("extension", taskDefinition.getConfiguration().get("extension"));
        context.put("linesplittermask", taskDefinition.getConfiguration().get("linesplittermask"));
        context.put("tokennumber", taskDefinition.getConfiguration().get("tokennumber"));
        context.put("testsuite", taskDefinition.getConfiguration().get("testsuite"));
        context.put("filefound", taskDefinition.getConfiguration().get("filefound"));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("errormask", taskDefinition.getConfiguration().get("errormask"));
        context.put("nonerrormask", taskDefinition.getConfiguration().get("nonerrormask"));
        context.put("filemask", taskDefinition.getConfiguration().get("filemask"));
        context.put("linemask", taskDefinition.getConfiguration().get("linemask"));
        context.put("extension", taskDefinition.getConfiguration().get("extension"));
        context.put("linesplittermask", taskDefinition.getConfiguration().get("linesplittermask"));
        context.put("tokennumber", taskDefinition.getConfiguration().get("tokennumber"));
        context.put("testsuite", taskDefinition.getConfiguration().get("testsuite"));
        context.put("filefound", taskDefinition.getConfiguration().get("filefound"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }
}

