/*
 * Decompiled with CFR 0.152.
 */
package org.valens;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.valens.LogParserCollector;

public class LogParserTask
implements TaskType {
    private final TestCollationService testCollationService;

    public LogParserTask(TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        CurrentBuildResult currentBuildResult = taskContext.getBuildContext().getBuildResult();
        Set failedTestResults = Collections.synchronizedSet(Sets.newHashSet());
        Set successfulTestResults = Collections.synchronizedSet(Sets.newHashSet());
        Set skippedTestResults = Collections.synchronizedSet(Sets.newHashSet());
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        String suite = (String)taskContext.getConfigurationMap().get((Object)"testsuite");
        String errormask = (String)taskContext.getConfigurationMap().get((Object)"errormask");
        String nonerrormask = (String)taskContext.getConfigurationMap().get((Object)"nonerrormask");
        String linemask = (String)taskContext.getConfigurationMap().get((Object)"linemask");
        String filefound = (String)taskContext.getConfigurationMap().get((Object)"filefound");
        String testFilePattern = (String)taskContext.getConfigurationMap().get((Object)"filemask");
        String linesplittermask = (String)taskContext.getConfigurationMap().get((Object)"linesplittermask");
        Integer tokennumber = 0;
        if (linesplittermask != null && linesplittermask.length() == 0) {
            linesplittermask = " ";
        }
        try {
            tokennumber = Integer.parseInt((String)taskContext.getConfigurationMap().get((Object)"tokennumber"));
        }
        catch (Exception e) {
            tokennumber = 0;
        }
        buildLogger.addBuildLogEntry("[" + errormask + "]");
        buildLogger.addBuildLogEntry("[" + nonerrormask + "]");
        buildLogger.addBuildLogEntry("[" + linemask + "]");
        buildLogger.addBuildLogEntry("[" + testFilePattern + "]");
        buildLogger.addBuildLogEntry("[" + linesplittermask + "]");
        buildLogger.addBuildLogEntry("[" + tokennumber + "]");
        try {
            FileSet fileSet = new FileSet();
            fileSet.setDir(taskContext.getRootDirectory());
            PatternSet.NameEntry include = fileSet.createInclude();
            include.setName(testFilePattern);
            DirectoryScanner ds = fileSet.getDirectoryScanner(new Project());
            String[] srcFiles = ds.getIncludedFiles();
            buildLogger.addBuildLogEntry("Root directory: " + taskContext.getRootDirectory());
            LogParserCollector lg = new LogParserCollector(filefound, suite, errormask, nonerrormask, linemask, linesplittermask, tokennumber);
            for (String s : srcFiles) {
                File file = new File(taskContext.getRootDirectory() + "/" + s);
                TestCollectionResult result = lg.collect(file);
                buildLogger.addBuildLogEntry(String.format("File %s parsing result: %d successful, %d failed, %d skipped", file, result.getSuccessfulTestResults().size(), result.getFailedTestResults().size(), result.getSkippedTestResults().size()));
                failedTestResults.addAll(result.getFailedTestResults());
                successfulTestResults.addAll(result.getSuccessfulTestResults());
            }
            buildResult.appendTestResults(successfulTestResults, failedTestResults, skippedTestResults);
            currentBuildResult.addBuildErrors(errorLines.getErrorStringList());
            return TaskResultBuilder.create((TaskContext)taskContext).checkTestFailures().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
    }
}

