/*
 * Decompiled with CFR 0.152.
 */
package org.valens;

import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class LogParserCollector
implements TestReportCollector {
    private String errormask = null;
    private String nonerrormask = null;
    private String linemask = null;
    private String suite = null;
    private String linesplittermask = null;
    private String filefound = null;
    private Integer tokennumber = 0;
    final Logger log = Logger.getLogger(TestCollationService.class);

    private LogParserCollector() {
    }

    public LogParserCollector(String filefound, String suite, String errormask, String nonerrormask, String linemask, String linesplittermask, Integer tokennumber) {
        this.suite = suite;
        this.filefound = filefound;
        this.errormask = errormask;
        this.nonerrormask = nonerrormask;
        this.linemask = linemask;
        this.linesplittermask = linesplittermask;
        this.tokennumber = tokennumber;
    }

    public TestCollectionResult collect(File file) throws Exception {
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        ArrayList successfulTestResults = Lists.newArrayList();
        ArrayList failingTestResults = Lists.newArrayList();
        List lines = Files.readLines((File)file, (Charset)Charset.forName("UTF-8"));
        int k = 0;
        if (this.filefound == null || this.filefound.equalsIgnoreCase("true")) {
            TestResults testResults1 = new TestResults("Test Files", file.getName(), "1.0");
            testResults1.setState(TestState.SUCCESS);
            successfulTestResults.add(testResults1);
        }
        for (String line : lines) {
            if (!line.matches(this.linemask)) continue;
            ++k;
            String suiteName = "Test Suite " + file.getAbsolutePath();
            if (this.suite != null && this.suite.trim().length() > 0) {
                suiteName = this.suite;
            }
            String testName = "";
            try {
                testName = line.split(this.linesplittermask)[this.tokennumber];
            }
            catch (Exception e) {
                testName = file.getName() + " test number " + k;
            }
            Double duration = 1.0;
            TestResults testResults = new TestResults(suiteName, testName, duration.toString());
            testResults.setSystemOut(line);
            if (line.matches(this.errormask) && !line.matches(this.nonerrormask)) {
                testResults.setState(TestState.FAILED);
                failingTestResults.add(testResults);
                continue;
            }
            testResults.setState(TestState.SUCCESS);
            successfulTestResults.add(testResults);
        }
        return builder.addSuccessfulTestResults((Collection)successfulTestResults).addFailedTestResults((Collection)failingTestResults).build();
    }

    public Set<String> getSupportedFileExtensions() {
        HashSet s = Sets.newHashSet((Object[])new String[]{"log"});
        s.add("LOG");
        return s;
    }
}

