/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import com.testingbot.tunnel.Api;
import com.testingbot.tunnel.App;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;

public class TunnelPoller {
    private final App app;
    private final Timer timer;
    private final String tunnelID;

    public TunnelPoller(App app, String tunnelID) {
        this.app = app;
        this.tunnelID = tunnelID;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PollTask(), 5000L, 5000L);
    }

    public void cancel() {
        this.timer.cancel();
    }

    class PollTask
    extends TimerTask {
        int counter = 0;

        PollTask() {
        }

        @Override
        public void run() {
            Api api = TunnelPoller.this.app.getApi();
            try {
                JSONObject response = api.pollTunnel(TunnelPoller.this.tunnelID);
                if (this.counter > 80) {
                    Logger.getLogger(TunnelPoller.class.getName()).log(Level.SEVERE, "Unable to create tunnel, waited for 400 seconds. Please try again or check https://status.testingbot.com");
                    TunnelPoller.this.timer.cancel();
                }
                if (response.getString("state").equals("READY")) {
                    TunnelPoller.this.timer.cancel();
                    TunnelPoller.this.app.tunnelReady(response);
                } else {
                    ++this.counter;
                    Logger.getLogger(TunnelPoller.class.getName()).log(Level.INFO, "Current tunnel status: {0}", response.getString("state"));
                }
            }
            catch (Exception ex) {
                TunnelPoller.this.timer.cancel();
                Logger.getLogger(TunnelPoller.class.getName()).log(Level.SEVERE, "Unable to poll for tunnel status.");
            }
        }
    }
}

