/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import com.testingbot.tunnel.App;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import ssh.CustomConnectionMonitor;

public class SSHTunnel {
    private final App app;
    private final Connection conn;
    private final String server;
    private Timer timer;
    private boolean authenticated = false;
    private boolean shuttingDown = false;
    private LocalPortForwarder lpf1;

    public SSHTunnel(App app, String server) throws Exception {
        this.app = app;
        this.server = server;
        this.conn = new Connection(server, 443);
        this.conn.addConnectionMonitor(new CustomConnectionMonitor(this, this.app));
        String[] ciphers = new String[]{"blowfish-cbc"};
        this.conn.setClient2ServerCiphers(ciphers);
        this.connect();
    }

    public final void connect() throws Exception {
        try {
            this.conn.connect();
        }
        catch (IOException ex) {
            Logger.getLogger(SSHTunnel.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        try {
            this.authenticated = this.conn.authenticateWithPassword(this.app.getClientKey(), this.app.getClientSecret());
        }
        catch (IOException ex) {
            Logger.getLogger(SSHTunnel.class.getName()).log(Level.SEVERE, "Failed authenticating to the tunnel. Please make sure you are supplying correct login credentials.");
            throw new Exception("Authentication failed: " + ex.getMessage());
        }
        if (!this.authenticated) {
            Logger.getLogger(SSHTunnel.class.getName()).log(Level.SEVERE, "Failed authenticating to the tunnel. Please make sure you are supplying correct login credentials.");
            throw new Exception("Authentication failed");
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PollTask(), 60000L, 60000L);
    }

    public void stop(boolean quitting) {
        this.shuttingDown = true;
        this.stop();
    }

    public void stop() {
        this.timer.cancel();
        this.conn.close();
        try {
            if (this.lpf1 != null) {
                this.lpf1.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SSHTunnel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createPortForwarding() {
        try {
            this.conn.openSession();
            this.conn.requestRemotePortForwarding(this.server, 2010, "0.0.0.0", this.app.getJettyPort());
            String hubHost = "hub.testingbot.com";
            this.lpf1 = this.conn.createLocalPortForwarder(this.app.getSSHPort(), hubHost, this.app.getHubPort());
        }
        catch (IOException ex) {
            Logger.getLogger(SSHTunnel.class.getName()).log(Level.SEVERE, "Could not setup port forwarding. Please make sure we can make an outbound connection to port 2010.");
        }
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    class PollTask
    extends TimerTask {
        PollTask() {
        }

        @Override
        public void run() {
            try {
                SSHTunnel.this.conn.sendIgnorePacket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

