/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import ch.ethz.ssh2.ConnectionMonitor;
import com.testingbot.tunnel.App;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import ssh.SSHTunnel;

public class CustomConnectionMonitor
implements ConnectionMonitor {
    private final SSHTunnel tunnel;
    private final App app;
    private Timer timer;
    private boolean retrying = false;

    public CustomConnectionMonitor(SSHTunnel tunnel, App app) {
        this.tunnel = tunnel;
        this.app = app;
    }

    @Override
    public void connectionLost(Throwable reason) {
        if (this.tunnel.isShuttingDown()) {
            return;
        }
        this.app.getHttpProxy().stop();
        Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.SEVERE, "SSH Connection lost! {0}", reason.getMessage());
        if (!this.retrying) {
            this.retrying = true;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new PollTask(), 5000L, 5000L);
        }
    }

    class PollTask
    extends TimerTask {
        private int retryAttempts = 0;

        PollTask() {
        }

        @Override
        public void run() {
            try {
                Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.INFO, "Trying to re-establish SSH Connection");
                ++this.retryAttempts;
                CustomConnectionMonitor.this.tunnel.stop();
                CustomConnectionMonitor.this.tunnel.connect();
                if (CustomConnectionMonitor.this.tunnel.isAuthenticated()) {
                    CustomConnectionMonitor.this.retrying = false;
                    this.retryAttempts = 0;
                    CustomConnectionMonitor.this.timer.cancel();
                    CustomConnectionMonitor.this.app.getHttpProxy().start();
                    CustomConnectionMonitor.this.tunnel.createPortForwarding();
                    Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.INFO, "Successfully re-established SSH Connection");
                    return;
                }
                Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.INFO, "Attempts {0}", this.retryAttempts);
            }
            catch (Exception ex) {
                Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.WARNING, ex.getMessage());
            }
            if (this.retryAttempts >= 3) {
                Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.INFO, "Giving up retrying this Connection. Creating a new Tunnel Connection.");
                CustomConnectionMonitor.this.timer.cancel();
                CustomConnectionMonitor.this.retrying = false;
                this.retryAttempts = 0;
                CustomConnectionMonitor.this.app.stop();
                try {
                    CustomConnectionMonitor.this.app.boot();
                }
                catch (Exception ex) {
                    Logger.getLogger(CustomConnectionMonitor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

