/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;

public class TestingBotLogHandler
extends AbstractLogger {
    private static final String THIS_CLASS = TestingBotLogHandler.class.getName();
    private static final boolean __source = Boolean.parseBoolean(Log.getProperties().getProperty("org.eclipse.jetty.util.log.SOURCE", Log.getProperties().getProperty("org.eclipse.jetty.util.log.javautil.SOURCE", "true")));
    private static boolean _initialized = false;
    private Level configuredLevel;
    private Logger _logger;

    public TestingBotLogHandler() {
        this("org.eclipse.jetty.util.log.javautil");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestingBotLogHandler(String name) {
        Class<TestingBotLogHandler> clazz = TestingBotLogHandler.class;
        synchronized (TestingBotLogHandler.class) {
            if (!_initialized) {
                _initialized = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this._logger = Logger.getLogger(name);
            this._logger.setLevel(Level.WARNING);
            this.configuredLevel = this._logger.getLevel();
            return;
        }
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    protected void log(Level level, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(level, msg);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        record.setLoggerName(this._logger.getName());
        if (__source) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                if (e.getClassName().equals(THIS_CLASS)) continue;
                record.setSourceClassName(e.getClassName());
                record.setSourceMethodName(e.getMethodName());
                break;
            }
        }
        this._logger.log(record);
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, this.format(msg, args), null);
        }
    }

    @Override
    public void warn(Throwable thrown) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, "", thrown);
        }
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, thrown);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, this.format(msg, args), null);
        }
    }

    @Override
    public void info(Throwable thrown) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, "", thrown);
        }
    }

    @Override
    public void info(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, thrown);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, this.format(msg, args), null);
        }
    }

    @Override
    public void debug(String msg, long arg) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, this.format(msg, arg), null);
        }
    }

    @Override
    public void debug(Throwable thrown) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "", thrown);
        }
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, thrown);
        }
    }

    @Override
    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new TestingBotLogHandler(fullname);
    }

    @Override
    public void ignore(Throwable ignored) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "IGNORED EXCEPTION ", ignored);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg, start, bracesIndex);
            builder.append(arg);
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

