/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.App;
import com.testingbot.tunnel.proxy.ForwarderServlet;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpForwarder {
    private App app;
    private final Server httpProxy;

    public HttpForwarder(App app) {
        this.app = app;
        this.httpProxy = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(this.httpProxy, new HttpConnectionFactory(http_config));
        connector.setPort(app.getSeleniumPort());
        connector.setIdleTimeout(440000L);
        this.httpProxy.setStopAtShutdown(true);
        this.httpProxy.addConnector(connector);
        ServletHolder servletHolder = new ServletHolder(new ForwarderServlet(app));
        servletHolder.setInitParameter("idleTimeout", "440000");
        servletHolder.setInitParameter("timeout", "440000");
        if (app.getProxy() != null) {
            servletHolder.setInitParameter("proxy", app.getProxy());
        }
        if (app.getProxyAuth() != null) {
            servletHolder.setInitParameter("proxyAuth", app.getProxyAuth());
        }
        ServletContextHandler ctxHandler = new ServletContextHandler(1);
        ctxHandler.setContextPath("/");
        ctxHandler.addServlet(servletHolder, "/*");
        this.httpProxy.setHandler(ctxHandler);
        try {
            this.httpProxy.start();
        }
        catch (Exception ex) {
            Logger.getLogger(HttpForwarder.class.getName()).log(Level.SEVERE, "Could not set up local forwarder. Please make sure this program can open port {0} on this computer.\nPerhaps another tunnel process is already running on this machine?", Integer.toString(app.getSeleniumPort()));
            Logger.getLogger(HttpForwarder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        try {
            this.httpProxy.stop();
        }
        catch (Exception ex) {
            Logger.getLogger(HttpForwarder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean testForwarding() {
        HttpResponse response;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet getRequest = new HttpGet("http://127.0.0.1:" + this.app.getSeleniumPort());
        try {
            response = httpClient.execute(getRequest);
        }
        catch (IOException ex) {
            return false;
        }
        return response.getStatusLine().getStatusCode() == 200;
    }
}

