/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.tunnel;

import com.testingbot.tunnel.App;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.iharder.Base64;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.message.BasicNameValuePair;

public class Api {
    private final String clientKey;
    private final String clientSecret;
    private final String apiHost = "api.testingbot.com";
    private final App app;
    private int tunnelID;

    public Api(App app) {
        this.app = app;
        this.clientKey = app.getClientKey();
        this.clientSecret = app.getClientSecret();
    }

    public JSONObject createTunnel() throws Exception {
        try {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("tunnel_version", App.VERSION.toString()));
            if (this.app.getTunnelIdentifier() != null && !this.app.getTunnelIdentifier().isEmpty()) {
                nameValuePairs.add(new BasicNameValuePair("tunnel_identifier", this.app.getTunnelIdentifier()));
            }
            if (this.app.isBypassingSquid()) {
                nameValuePairs.add(new BasicNameValuePair("no_cache", String.valueOf(this.app.isBypassingSquid())));
            }
            return this._post("https://api.testingbot.com/v1/tunnel/create", nameValuePairs);
        }
        catch (Exception e) {
            throw new Exception("Could not start tunnel: " + e.getMessage());
        }
    }

    public void setTunnelID(int tunnelID) {
        this.tunnelID = tunnelID;
    }

    public JSONObject pollTunnel(String tunnelID) throws Exception {
        try {
            return this._get("https://api.testingbot.com/v1/tunnel/" + tunnelID);
        }
        catch (Exception e) {
            throw new Exception("Could not get tunnel info: " + e.getMessage());
        }
    }

    public void destroyTunnel() throws Exception {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder.setConnectTimeout(1000);
        requestBuilder.setConnectionRequestTimeout(1000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        if (this.app.getProxy() != null) {
            int port;
            String[] splitted = this.app.getProxy().split(":");
            int n = port = splitted.length > 1 ? Integer.parseInt(splitted[1]) : 80;
            if (this.app.getProxyAuth() != null) {
                String[] credentials = this.app.getProxyAuth().split(":");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(splitted[0], port), new UsernamePasswordCredentials(credentials[0], credentials[1]));
                builder.setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy()).setDefaultCredentialsProvider(credsProvider);
            }
            HttpHost proxy = new HttpHost(splitted[0], port, "http");
            builder.setProxy(proxy);
        }
        try (CloseableHttpClient httpClient = builder.build();){
            String auth = this.clientKey + ":" + this.clientSecret;
            String encoding = Base64.encodeBytes(auth.getBytes("UTF-8"));
            HttpDelete deleteRequest = new HttpDelete("https://api.testingbot.com/v1/tunnel/" + this.tunnelID);
            deleteRequest.addHeader("accept", "application/json");
            deleteRequest.setHeader("Authorization", "Basic " + encoding);
            httpClient.execute(deleteRequest);
        }
    }

    private JSONObject _post(String url, List<NameValuePair> postData) throws Exception {
        try {
            StringBuilder sb;
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (this.app.getProxy() != null) {
                int port;
                String[] splitted = this.app.getProxy().split(":");
                int n = port = splitted.length > 1 ? Integer.parseInt(splitted[1]) : 80;
                if (this.app.getProxyAuth() != null) {
                    String[] credentials = this.app.getProxyAuth().split(":");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(splitted[0], port), new UsernamePasswordCredentials(credentials[0], credentials[1]));
                    builder.setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy()).setDefaultCredentialsProvider(credsProvider);
                }
                HttpHost proxy = new HttpHost(splitted[0], port, "http");
                builder.setProxy(proxy);
            }
            try (CloseableHttpClient httpClient = builder.build();){
                String output;
                String auth = this.clientKey + ":" + this.clientSecret;
                String encoding = Base64.encodeBytes(auth.getBytes("UTF-8"));
                HttpPost postRequest = new HttpPost(url);
                postRequest.addHeader("accept", "application/json");
                postRequest.setHeader("Authorization", "Basic " + encoding);
                postRequest.setEntity(new UrlEncodedFormEntity(postData));
                CloseableHttpResponse response = httpClient.execute(postRequest);
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF8"));
                sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
            }
            try {
                String jsonData = sb.toString().replaceAll("\\\\", "");
                if (!jsonData.startsWith("{")) {
                    jsonData = jsonData.substring(1, jsonData.length() - 1);
                }
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON(jsonData);
                return jsonObject;
            }
            catch (JSONException e) {
                throw new Exception("Json parse error: " + e.getMessage() + " for " + sb.toString());
            }
        }
        catch (ClientProtocolException e) {
            throw new Exception(e.getMessage());
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    private JSONObject _get(String url) throws Exception {
        try {
            StringBuilder sb;
            HttpClientBuilder builder = HttpClientBuilder.create();
            if (this.app.getProxy() != null) {
                int port;
                String[] splitted = this.app.getProxy().split(":");
                int n = port = splitted.length > 1 ? Integer.parseInt(splitted[1]) : 80;
                if (this.app.getProxyAuth() != null) {
                    String[] credentials = this.app.getProxyAuth().split(":");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(splitted[0], port), new UsernamePasswordCredentials(credentials[0], credentials[1]));
                    builder.setProxyAuthenticationStrategy(new ProxyAuthenticationStrategy()).setDefaultCredentialsProvider(credsProvider);
                }
                HttpHost proxy = new HttpHost(splitted[0], port, "http");
                builder.setProxy(proxy);
            }
            try (CloseableHttpClient httpClient = builder.build();){
                String output;
                String auth = this.clientKey + ":" + this.clientSecret;
                String encoding = Base64.encodeBytes(auth.getBytes("UTF-8"));
                HttpGet getRequest = new HttpGet(url);
                getRequest.addHeader("accept", "application/json");
                getRequest.setHeader("Authorization", "Basic " + encoding);
                CloseableHttpResponse response = httpClient.execute(getRequest);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF8"));
                sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
            }
            try {
                String jsonData = sb.toString().replaceAll("\\\\", "");
                if (!jsonData.startsWith("{")) {
                    jsonData = jsonData.substring(1, jsonData.length() - 1);
                }
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON(jsonData);
                return jsonObject;
            }
            catch (JSONException e) {
                throw new Exception("Json parse error: " + e.getMessage() + " for " + sb.toString());
            }
        }
        catch (ClientProtocolException e) {
            throw new Exception(e.getMessage());
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }
}

