/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.testingbotrest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.testingbot.BuildUtils;
import com.testingbot.models.TestingBotStorageFile;
import com.testingbot.models.TestingBotStorageFileCollection;
import com.testingbot.models.TestingbotBrowser;
import com.testingbot.models.TestingbotBuildCollection;
import com.testingbot.models.TestingbotDevice;
import com.testingbot.models.TestingbotStorageUploadResponse;
import com.testingbot.models.TestingbotTest;
import com.testingbot.models.TestingbotTestBuildCollection;
import com.testingbot.models.TestingbotTestCollection;
import com.testingbot.models.TestingbotTunnel;
import com.testingbot.models.TestingbotUser;
import com.testingbot.testingbotrest.TestingbotApiException;
import com.testingbot.testingbotrest.TestingbotUnauthorizedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class TestingbotREST {
    protected String key;
    protected String secret;
    private final Gson gson;

    public TestingbotREST(String key, String secret) {
        this.key = key;
        this.secret = secret;
        this.gson = new GsonBuilder().create();
    }

    public boolean updateTest(TestingbotTest test) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("status_message", test.getStatusMessage());
        details.put("success", test.isSuccess());
        details.put("build", test.getBuild());
        details.put("extra", test.getExtra());
        details.put("name", test.getName());
        details.put("groups", test.getGroups());
        return this.updateTest(test.getSessionId(), details);
    }

    public boolean updateTest(String sessionID, Map<String, Object> details) {
        return this.apiUpdate("https://api.testingbot.com/v1/tests/" + sessionID, details);
    }

    public boolean stopTest(String sessionID) {
        return this.apiUpdate("https://api.testingbot.com/v1/tests/" + sessionID + "/stop", null);
    }

    public boolean deleteTest(String sessionID) {
        return this.apiDelete("https://api.testingbot.com/v1/tests/" + sessionID);
    }

    public ArrayList<TestingbotBrowser> getBrowsers() {
        return (ArrayList)this.apiGet("https://api.testingbot.com/v1/browsers", TypeToken.getParameterized(ArrayList.class, new Type[]{TestingbotBrowser.class}).getType());
    }

    public TestingbotTestCollection getTests(int offset, int count) {
        return (TestingbotTestCollection)this.apiGet("https://api.testingbot.com/v1/tests/?offset=" + offset + "&count=" + count, new TypeToken<TestingbotTestCollection>(){}.getType());
    }

    public TestingbotTest getTest(String sessionID) {
        return (TestingbotTest)this.apiGet("https://api.testingbot.com/v1/tests/" + sessionID, new TypeToken<TestingbotTest>(){}.getType());
    }

    public TestingbotUser getUserInfo() {
        return (TestingbotUser)this.apiGet("https://api.testingbot.com/v1/user", new TypeToken<TestingbotUser>(){}.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserInfo(TestingbotUser testingbotUser) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            HttpPut putRequest = new HttpPut("https://api.testingbot.com/v1/user/");
            putRequest.setHeader("Authorization", "Basic " + encoding);
            putRequest.setHeader("User-Agent", this.getUserAgent());
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("user[first_name]", testingbotUser.getFirstName()));
            nameValuePairs.add(new BasicNameValuePair("user[last_name]", testingbotUser.getLastName()));
            putRequest.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
            HttpResponse response = httpClient.execute(putRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            String payload = sb.toString();
            if (response.getStatusLine().getStatusCode() > 200) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(payload);
            }
            JSONObject json = new JSONObject(payload);
            boolean bl = json.getBoolean("success");
            return bl;
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayList<TestingbotTunnel> getTunnels() {
        return (ArrayList)this.apiGet("https://api.testingbot.com/v1/tunnel/list", TypeToken.getParameterized(ArrayList.class, new Type[]{TestingbotTunnel.class}).getType());
    }

    public boolean deleteTunnel(String tunnelID) {
        return this.apiDelete("https://api.testingbot.com/v1/tunnel/" + tunnelID);
    }

    public TestingbotTestBuildCollection getTestsForBuild(String buildIdentifier) {
        return (TestingbotTestBuildCollection)this.apiGet("https://api.testingbot.com/v1/builds/" + buildIdentifier, new TypeToken<TestingbotTestBuildCollection>(){}.getType());
    }

    public TestingbotBuildCollection getBuilds(int offset, int count) {
        return (TestingbotBuildCollection)this.apiGet("https://api.testingbot.com/v1/builds/?offset=" + offset + "&count=" + count, new TypeToken<TestingbotBuildCollection>(){}.getType());
    }

    public boolean deleteBuild(String buildId) {
        return this.apiDelete("https://api.testingbot.com/v1/builds/" + buildId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestingbotStorageUploadResponse uploadToStorage(File file) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            HttpPost post = new HttpPost("https://api.testingbot.com/v1/storage");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("file", file, ContentType.DEFAULT_BINARY, file.getName());
            HttpEntity entity = builder.build();
            post.setHeader("Authorization", "Basic " + encoding);
            post.setHeader("User-Agent", this.getUserAgent());
            post.setEntity(entity);
            HttpResponse response = httpClient.execute(post);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            if (response.getStatusLine().getStatusCode() >= 400) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(sb.toString());
            }
            TestingbotStorageUploadResponse testingbotStorageUploadResponse = this.gson.fromJson(sb.toString(), TestingbotStorageUploadResponse.class);
            return testingbotStorageUploadResponse;
        }
        catch (IOException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            TestingbotStorageUploadResponse testingbotStorageUploadResponse = new TestingbotStorageUploadResponse();
            return testingbotStorageUploadResponse;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestingbotStorageUploadResponse uploadToStorage(String url) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            HttpPost post = new HttpPost("https://api.testingbot.com/v1/storage");
            post.setHeader("Authorization", "Basic " + encoding);
            post.setHeader("User-Agent", this.getUserAgent());
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
            nameValuePairs.add(new BasicNameValuePair("url", url));
            post.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
            HttpResponse response = httpClient.execute(post);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            if (response.getStatusLine().getStatusCode() >= 400) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(sb.toString());
            }
            TestingbotStorageUploadResponse testingbotStorageUploadResponse = this.gson.fromJson(sb.toString(), TestingbotStorageUploadResponse.class);
            return testingbotStorageUploadResponse;
        }
        catch (IOException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            TestingbotStorageUploadResponse testingbotStorageUploadResponse = new TestingbotStorageUploadResponse();
            return testingbotStorageUploadResponse;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public TestingBotStorageFile getStorageFile(String appUrl) {
        return (TestingBotStorageFile)this.apiGet("https://api.testingbot.com/v1/storage/" + appUrl.replace("tb://", ""), new TypeToken<TestingBotStorageFile>(){}.getType());
    }

    public TestingBotStorageFileCollection getStorageFiles(int offset, int count) {
        return (TestingBotStorageFileCollection)this.apiGet("https://api.testingbot.com/v1/storage/?offset=" + offset + "&count=" + count, new TypeToken<TestingBotStorageFileCollection>(){}.getType());
    }

    public List<TestingbotDevice> getAvailableDevices(int offset, int count) {
        return (List)this.apiGet("https://api.testingbot.com/v1/devices/available/?offset=" + offset + "&count=" + count, TypeToken.getParameterized(List.class, new Type[]{TestingbotDevice.class}).getType());
    }

    public List<TestingbotDevice> getDevices(int offset, int count) {
        return (List)this.apiGet("https://api.testingbot.com/v1/devices/?offset=" + offset + "&count=" + count, TypeToken.getParameterized(List.class, new Type[]{TestingbotDevice.class}).getType());
    }

    public TestingbotDevice getDevice(int deviceId) {
        return (TestingbotDevice)this.apiGet("https://api.testingbot.com/v1/devices/" + deviceId, new TypeToken<TestingbotDevice>(){}.getType());
    }

    public boolean deleteStorageFile(String appUrl) {
        return this.apiDelete("https://api.testingbot.com/v1/storage/" + appUrl);
    }

    public String getAuthenticationHash(String identifier) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            String s = this.key + ":" + this.secret + ":" + identifier;
            m.update(s.getBytes(StandardCharsets.UTF_8), 0, s.length());
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getAuthenticationHash() {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            String s = this.key + ":" + this.secret;
            m.update(s.getBytes(StandardCharsets.UTF_8), 0, s.length());
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String getUserAgent() {
        return "TestingBotRest/" + BuildUtils.getCurrentVersion();
    }

    private <T> T apiGet(String url, Type returnType) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            HttpGet getRequest = new HttpGet(url);
            getRequest.setHeader("Authorization", "Basic " + encoding);
            getRequest.setHeader("User-Agent", this.getUserAgent());
            HttpResponse response = httpClient.execute(getRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            if (response.getStatusLine().getStatusCode() > 200) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(sb.toString());
            }
            Object t = this.gson.fromJson(sb.toString(), returnType);
            return t;
        }
        catch (IOException | JSONException ex) {
            throw new TestingbotApiException(ex.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apiUpdate(String url, Map<String, Object> details) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            HttpPut putRequest = new HttpPut(url);
            putRequest.setHeader("Authorization", "Basic " + encoding);
            putRequest.setHeader("User-Agent", this.getUserAgent());
            if (details != null) {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
                for (Map.Entry<String, Object> entry : details.entrySet()) {
                    if (entry.getKey().equals("groups")) {
                        for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                            nameValuePairs.add(new BasicNameValuePair("groups[]", ((List)entry.getValue()).get(i).toString()));
                        }
                        continue;
                    }
                    if (entry.getValue() == null) continue;
                    nameValuePairs.add(new BasicNameValuePair("test[" + entry.getKey() + "]", entry.getValue().toString()));
                }
                putRequest.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs));
            }
            HttpResponse response = httpClient.execute(putRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            String payload = sb.toString();
            if (response.getStatusLine().getStatusCode() > 200) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(payload);
            }
            JSONObject json = new JSONObject(payload);
            boolean bl = json.getBoolean("success");
            return bl;
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apiDelete(String url) {
        BufferedReader br = null;
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpDelete deleteRequest = new HttpDelete(url);
            String userpass = this.key + ":" + this.secret;
            String encoding = Base64.encodeBytes(userpass.getBytes(StandardCharsets.UTF_8));
            deleteRequest.setHeader("Authorization", "Basic " + encoding);
            deleteRequest.setHeader("User-Agent", this.getUserAgent());
            HttpResponse response = httpClient.execute(deleteRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            String payload = sb.toString();
            if (response.getStatusLine().getStatusCode() > 200) {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new TestingbotUnauthorizedException();
                }
                throw new TestingbotApiException(payload);
            }
            JSONObject json = new JSONObject(payload);
            boolean bl = json.getBoolean("success");
            return bl;
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

