/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.variables;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationManager;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.variables.VariableModifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DefaultVariableModifier
implements VariableModifier {
    private static final Logger logger = Logger.getLogger(DefaultVariableModifier.class);
    private CustomVariableContext customVariableContext;
    protected static final String EQUALS = "=\"";
    protected MappedBuildConfiguration config;
    protected AdministrationConfigurationManager administrationConfigurationManager;
    protected BuildDefinition definition;
    protected BuildContext buildContext;

    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public DefaultVariableModifier(MappedBuildConfiguration config, BuildDefinition definition, BuildContext buildContext, CustomVariableContext customVariableContext) {
        this.config = config;
        this.definition = definition;
        this.buildContext = buildContext;
        this.customVariableContext = customVariableContext;
    }

    protected Map<String, VariableDefinitionContext> createSeleniumVariableContext(VariableContext variableContext) {
        HashMap<String, VariableDefinitionContext> variables = new HashMap<String, VariableDefinitionContext>();
        AdministrationConfiguration adminConfig = this.administrationConfigurationManager.getAdministrationConfiguration();
        this.createCommonEnvironmentVariables(variableContext, adminConfig);
        return variables;
    }

    private void addVariable(VariableContext variables, String key, String value) {
        variables.addLocalVariable(key, value);
        VariableDefinitionContext variableDefinitionContext = (VariableDefinitionContext)variables.getEffectiveVariables().get(key);
        if (variableDefinitionContext != null) {
            variableDefinitionContext.setVariableType(VariableType.ENVIRONMENT);
        }
    }

    private void createCommonEnvironmentVariables(VariableContext variables, AdministrationConfiguration adminConfig) {
        if (this.config.shouldOverrideAuthentication() && StringUtils.isNotEmpty(this.config.getKey())) {
            this.config.setTempKey(this.config.getKey());
        } else {
            this.config.setTempKey(adminConfig.getSystemProperty("tb.key"));
        }
        if (this.config.shouldOverrideAuthentication() && StringUtils.isNotEmpty(this.config.getSecret())) {
            this.config.setTempSecret(this.config.getSecret());
        } else {
            this.config.setTempSecret(adminConfig.getSystemProperty("tb.secret"));
        }
        this.addVariable(variables, "SELENIUM_HOST", this.config.getSshHost());
        this.addVariable(variables, "SELENIUM_PORT", this.config.getSshPorts());
        this.addVariable(variables, "TB_KEY", this.config.getTempKey());
        this.addVariable(variables, "TESTINGBOT_KEY", this.config.getTempKey());
        this.addVariable(variables, "TB_SECRET", this.config.getTempSecret());
        this.addVariable(variables, "TESTINGBOT_SECRET", this.config.getTempSecret());
        if (this.buildContext.getParentBuildContext() == null) {
            this.addVariable(variables, "TB_BAMBOO_BUILDNUMBER", this.buildContext.getBuildResultKey());
        } else {
            this.addVariable(variables, "TB_BAMBOO_BUILDNUMBER", this.buildContext.getParentBuildContext().getBuildResultKey());
        }
        if (this.config.useGeneratedTunnelIdentifier()) {
            VariableDefinitionContext key = (VariableDefinitionContext)this.customVariableContext.getVariableContexts().get("TUNNEL_IDENTIFIER");
            String tunnelIdentifier = key == null ? null : key.getValue();
            this.addVariable(variables, "TUNNEL_IDENTIFIER", tunnelIdentifier);
        }
    }

    @Override
    public void setAdministrationConfigurationManager(AdministrationConfigurationManager administrationConfigurationManager) {
        this.administrationConfigurationManager = administrationConfigurationManager;
    }

    protected String createSeleniumEnvironmentVariables() {
        return this.createSeleniumEnvironmentVariables("");
    }

    protected String createSeleniumEnvironmentVariables(String prefix) {
        AdministrationConfiguration adminConfig = this.administrationConfigurationManager.getAdministrationConfiguration();
        StringBuilder stringBuilder = new StringBuilder();
        this.createCommonEnvironmentVariables(prefix, stringBuilder, adminConfig);
        return stringBuilder.toString();
    }

    private void createCommonEnvironmentVariables(String prefix, StringBuilder stringBuilder, AdministrationConfiguration adminConfig) {
        if (this.config.shouldOverrideAuthentication() && StringUtils.isNotEmpty(this.config.getKey())) {
            this.config.setTempKey(this.config.getKey());
        } else {
            this.config.setTempKey(adminConfig.getSystemProperty("tb.key"));
        }
        if (this.config.shouldOverrideAuthentication() && StringUtils.isNotEmpty(this.config.getSecret())) {
            this.config.setTempSecret(this.config.getSecret());
        } else {
            this.config.setTempSecret(adminConfig.getSystemProperty("tb.secret"));
        }
        stringBuilder.append(' ').append(prefix).append("SELENIUM_HOST").append(EQUALS).append(this.config.getSshHost()).append('\"');
        stringBuilder.append(' ').append(prefix).append("SELENIUM_PORT").append(EQUALS).append(this.config.getSshPorts()).append('\"');
        stringBuilder.append(' ').append(prefix).append("TESTINGBOT_KEY").append(EQUALS).append(this.config.getTempKey()).append('\"');
        stringBuilder.append(' ').append(prefix).append("TB_KEY").append(EQUALS).append(this.config.getTempKey()).append('\"');
        stringBuilder.append(' ').append(prefix).append("TB_SECRET").append(EQUALS).append(this.config.getTempSecret()).append('\"');
        stringBuilder.append(' ').append(prefix).append("TESTINGBOT_SECRET").append(EQUALS).append(this.config.getTempSecret()).append('\"');
        if (this.buildContext.getParentBuildContext() == null) {
            stringBuilder.append(' ').append(prefix).append("TB_BAMBOO_BUILDNUMBER").append(EQUALS).append(this.buildContext.getBuildResultKey()).append('\"');
        } else {
            stringBuilder.append(' ').append(prefix).append("TB_BAMBOO_BUILDNUMBER").append(EQUALS).append(this.buildContext.getParentBuildContext().getBuildResultKey()).append('\"');
        }
        if (this.config.useGeneratedTunnelIdentifier()) {
            VariableDefinitionContext key = (VariableDefinitionContext)this.customVariableContext.getVariableContexts().get("TUNNEL_IDENTIFIER");
            String tunnelIdentifier = key == null ? null : key.getValue();
            stringBuilder.append(' ').append(prefix).append("TUNNEL_IDENTIFIER").append(EQUALS).append(tunnelIdentifier).append('\"');
        }
    }
}

