/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.util;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TestingBotLogInterceptor
implements LogInterceptor {
    private static final Logger logger = Logger.getLogger(TestingBotLogInterceptor.class);
    private final BuildContext buildContext;

    public TestingBotLogInterceptor(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void intercept(@NotNull LogEntry logEntry) {
        if (StringUtils.containsIgnoreCase(logEntry.getLog(), "TestingBotSessionID")) {
            logger.info((Object)("Adding log entry: " + logEntry.getLog()));
            CurrentBuildResult buildResult = this.buildContext.getBuildResult();
            buildResult.getCustomBuildData().put("TB_JOB_ID_" + System.currentTimeMillis(), logEntry.getLog());
        } else {
            logger.info((Object)("Skipping line " + logEntry.getLog()));
        }
    }

    public void interceptError(@NotNull LogEntry logEntry) {
        if (StringUtils.containsIgnoreCase(logEntry.getLog(), "TestingBotSessionID")) {
            logger.info((Object)("Adding log entry: " + logEntry.getLog()));
            CurrentBuildResult buildResult = this.buildContext.getBuildResult();
            buildResult.getCustomBuildData().put("TB_JOB_ID_" + System.currentTimeMillis(), logEntry.getLog());
        } else {
            logger.info((Object)("Skipping line " + logEntry.getLog()));
        }
    }
}

