/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.plan;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.google.gson.Gson;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.models.TestingbotTest;
import com.testingbot.bamboo.models.TestingbotTestBuildCollection;
import com.testingbot.testingbotrest.TestingbotApiException;
import com.testingbot.testingbotrest.TestingbotREST;
import com.testingbot.testingbotrest.TestingbotUnauthorizedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

public class ViewTestingBotAction
extends ViewBuildResults {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(ViewTestingBotAction.class);
    private AdministrationConfigurationManager administrationConfigurationManager;
    private List<TestingbotTest> jobInformation;

    public String doDefault() throws Exception {
        String secret;
        String key;
        logger.info((Object)"Trying to get the TestingBot tests in this build");
        this.jobInformation = new ArrayList<TestingbotTest>();
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan instanceof ImmutableChain) {
            List chains = this.cachedPlanManager.getPlansByProject(this.getImmutablePlan().getProject(), ImmutableChain.class);
            for (ImmutableJob job : ((ImmutableChain)plan).getAllJobs()) {
                MappedBuildConfiguration config = new MappedBuildConfiguration(job.getBuildDefinition().getCustomConfiguration());
                if (StringUtils.isNotEmpty(config.getKey())) {
                    key = config.getKey();
                    secret = config.getSecret();
                    this.jobInformation.addAll(this.retrieveJobIds(key, secret));
                }
                if (this.jobInformation.isEmpty()) continue;
                break;
            }
        }
        if (this.jobInformation.isEmpty()) {
            AdministrationConfiguration adminConfig = this.administrationConfigurationManager.getAdministrationConfiguration();
            key = adminConfig.getSystemProperty("tb.key");
            secret = adminConfig.getSystemProperty("tb.secret");
            this.jobInformation.addAll(this.retrieveJobIds(key, secret));
        }
        return super.doDefault();
    }

    public TestingbotTestBuildCollection getTestsForBuild(String key, String secret, String buildIdentifier) {
        try {
            String output;
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            String userpass = key + ":" + secret;
            String encoding = Base64.encodeBytes(userpass.getBytes("UTF-8"));
            HttpGet getRequest = new HttpGet("https://api.testingbot.com/v1/builds/" + buildIdentifier);
            getRequest.setHeader("Authorization", "Basic " + encoding);
            HttpResponse response = httpClient.execute(getRequest);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF8"));
            StringBuilder sb = new StringBuilder();
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            if (response.getStatusLine().getStatusCode() > 200) {
                throw new TestingbotUnauthorizedException();
            }
            Gson gson = new Gson();
            return gson.fromJson(sb.toString(), TestingbotTestBuildCollection.class);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TestingbotREST.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private ArrayList<TestingbotTest> retrieveJobIds(String key, String secret) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String buildName = PlanKeys.getPlanResultKey((PlanKey)this.resultsSummary.getPlanKey(), (int)this.getResultsSummary().getBuildNumber()).getKey();
        try {
            TestingbotTestBuildCollection testCollection = this.getTestsForBuild(key, secret, buildName);
            return testCollection.getData();
        }
        catch (TestingbotApiException ex) {
            return new ArrayList<TestingbotTest>();
        }
    }

    public void setAdministrationConfigurationManager(AdministrationConfigurationManager administrationConfigurationManager) {
        this.administrationConfigurationManager = administrationConfigurationManager;
    }

    public List<TestingbotTest> getJobInformation() {
        return this.jobInformation;
    }

    public boolean isRestartable(@NotNull ResultsSummary resultsSummary) {
        return false;
    }
}

