/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.config;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;

public class MappedBuildConfiguration {
    private final Map<String, String> map;

    public MappedBuildConfiguration(Map<String, String> map) {
        this.map = map;
    }

    public boolean shouldOverrideAuthentication() {
        return this.map.get("custom.testingbot.auth.enabled") != null && this.map.get("custom.testingbot.auth.enabled").equals("true");
    }

    public String getKey() {
        return this.map.get("custom.testingbot.key");
    }

    public String getSecret() {
        return this.map.get("custom.testingbot.secret");
    }

    public static String[] fromString(String string) {
        if (string == null) {
            return new String[0];
        }
        String[] strings = string.replace("[", "").replace("]", "").split(", ");
        String[] result = new String[strings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings[i];
        }
        return result;
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.map.get("custom.testingbot.enabled"));
    }

    public boolean isTunnelEnabled() {
        return Boolean.parseBoolean(this.map.get("custom.testingbot.ssh.enabled"));
    }

    public boolean isVerboseSSHLogging() {
        return Boolean.parseBoolean(this.map.get("custom.testingbot.ssh.verbose"));
    }

    public boolean useGeneratedTunnelIdentifier() {
        return Boolean.parseBoolean(this.map.get("custom.testingbot.ssh.useGeneratedTunnelIdentifier"));
    }

    public String getSshPorts() {
        String port = this.map.get("SELENIUM_PORT");
        if (port == null) {
            port = this.map.get("custom.testingbot.selenium.port");
        }
        if (port == null || port.equals("")) {
            port = this.isTunnelEnabled() ? "4445" : "80";
        } else if (port == "0") {
            try {
                ServerSocket s = new ServerSocket(0);
                System.out.println("Port was 0, listening on port: " + s.getLocalPort());
                port = Integer.toString(s.getLocalPort());
            }
            catch (IOException e) {
                port = this.isTunnelEnabled() ? "4445" : "80";
            }
        }
        this.map.put("SELENIUM_PORT", port);
        return port;
    }

    public String getSshHost() {
        String host = this.map.get("custom.testingbot.selenium.host");
        if (host == null || host.equals("")) {
            host = this.isTunnelEnabled() ? "localhost" : "hub.testingbot.com";
        }
        return host;
    }

    public String getTempKey() {
        return this.map.get("custom.testingbot.temp.key");
    }

    public void setTempKey(String user) {
        this.map.put("custom.testingbot.temp.key", user);
    }

    public String getTempSecret() {
        return this.map.get("custom.testingbot.temp.secret");
    }

    public void setTempSecret(String key) {
        this.map.put("custom.testingbot.temp.secret", key);
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public String getTunnelOptions() {
        return this.map.get("custom.testingbot.tunnelOptions");
    }
}

