/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.compression;

import ch.ethz.ssh2.compression.ICompressor;
import com.jcraft.jzlib.ZStream;

public class Zlib
implements ICompressor {
    private static final int DEFAULT_BUF_SIZE = 4096;
    private static final int LEVEL = 5;
    private ZStream deflate = new ZStream();
    private byte[] deflate_tmpbuf;
    private ZStream inflate = new ZStream();
    private byte[] inflate_tmpbuf;
    private byte[] inflated_buf;

    public Zlib() {
        this.deflate.deflateInit(5);
        this.inflate.inflateInit();
        this.deflate_tmpbuf = new byte[4096];
        this.inflate_tmpbuf = new byte[4096];
        this.inflated_buf = new byte[4096];
    }

    @Override
    public boolean canCompressPreauth() {
        return true;
    }

    @Override
    public int getBufferSize() {
        return 4096;
    }

    @Override
    public int compress(byte[] buf, int start, int len, byte[] output) {
        this.deflate.next_in = buf;
        this.deflate.next_in_index = start;
        this.deflate.avail_in = len - start;
        if (buf.length + 1024 > this.deflate_tmpbuf.length) {
            this.deflate_tmpbuf = new byte[buf.length + 1024];
        }
        this.deflate.next_out = this.deflate_tmpbuf;
        this.deflate.next_out_index = 0;
        this.deflate.avail_out = output.length;
        if (this.deflate.deflate(1) != 0) {
            System.err.println("compress: compression failure");
        }
        if (this.deflate.avail_in > 0) {
            System.err.println("compress: deflated data too large");
        }
        int outputlen = output.length - this.deflate.avail_out;
        System.arraycopy(this.deflate_tmpbuf, 0, output, 0, outputlen);
        return outputlen;
    }

    @Override
    public byte[] uncompress(byte[] buffer, int start, int[] length) {
        int status;
        int inflated_end = 0;
        this.inflate.next_in = buffer;
        this.inflate.next_in_index = start;
        this.inflate.avail_in = length[0];
        block4: while (true) {
            this.inflate.next_out = this.inflate_tmpbuf;
            this.inflate.next_out_index = 0;
            this.inflate.avail_out = 4096;
            status = this.inflate.inflate(1);
            switch (status) {
                case 0: {
                    byte[] foo;
                    if (this.inflated_buf.length < inflated_end + 4096 - this.inflate.avail_out) {
                        foo = new byte[inflated_end + 4096 - this.inflate.avail_out];
                        System.arraycopy(this.inflated_buf, 0, foo, 0, inflated_end);
                        this.inflated_buf = foo;
                    }
                    System.arraycopy(this.inflate_tmpbuf, 0, this.inflated_buf, inflated_end, 4096 - this.inflate.avail_out);
                    length[0] = inflated_end += 4096 - this.inflate.avail_out;
                    continue block4;
                }
                case -5: {
                    byte[] foo;
                    if (inflated_end > buffer.length - start) {
                        foo = new byte[inflated_end + start];
                        System.arraycopy(buffer, 0, foo, 0, start);
                        System.arraycopy(this.inflated_buf, 0, foo, start, inflated_end);
                        buffer = foo;
                    } else {
                        System.arraycopy(this.inflated_buf, 0, buffer, start, inflated_end);
                    }
                    length[0] = inflated_end;
                    return buffer;
                }
            }
            break;
        }
        System.err.println("uncompress: inflate returnd " + status);
        return null;
    }
}

