/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.tfs;

import com.stellarity.tfs.ProjectInfo;

public class WebUrlGenerator {
    public static String createChangesetUrl(ProjectInfo info, String changeset) {
        return String.format("%s/web/cs.aspx?pcguid=%s&cs=%s", WebUrlGenerator.preprocessBaseUrl(info), info.getProgetGuid(), changeset);
    }

    public static String createFileUrl(ProjectInfo info, String path) {
        return String.format("%s/web/scc.aspx?pcguid=%s&path=%s", WebUrlGenerator.preprocessBaseUrl(info), info.getProgetGuid(), path);
    }

    public static String createRevisionUrl(ProjectInfo info, String revision, String path) {
        return String.format("%s/web/view.aspx?pcguid=%s&cs=%s&path=%s", WebUrlGenerator.preprocessBaseUrl(info), info.getProgetGuid(), revision, path);
    }

    public static String createDiffUrl(ProjectInfo info, String revision, String path) {
        return String.format("%s/web/diff.aspx?pcguid=%s&mcs=%s&opath=%s", WebUrlGenerator.preprocessBaseUrl(info), info.getProgetGuid(), revision, path);
    }

    private static String preprocessBaseUrl(ProjectInfo info) {
        if (info.getPre2010()) {
            return info.getBaseUrl();
        }
        return WebUrlGenerator.stripTfsCollection(info.getBaseUrl());
    }

    private static String stripTfsCollection(String baseUrl) {
        int idx = baseUrl.lastIndexOf("/");
        return baseUrl.substring(0, idx);
    }
}

