/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TfsUtils {
    @NotNull
    public static Changeset[] queryHistory(@NotNull VersionControlClient vcc, @Nullable String serverOrLocalPath, @Nullable VersionSpec version, @Nullable VersionSpec versionFrom, @Nullable VersionSpec versionTo, int maxCount, boolean includeFileDetails) throws ServerPathFormatException {
        int lastChangesetId;
        int firstChangesetId;
        Object[] changesets = vcc.queryHistory(serverOrLocalPath, (VersionSpec)(version != null ? version : LatestVersionSpec.INSTANCE), 0, RecursionType.FULL, null, versionFrom, versionTo, maxCount, includeFileDetails, true, false, true);
        if (changesets.length > 0 && (firstChangesetId = changesets[0].getChangesetID()) > (lastChangesetId = changesets[changesets.length - 1].getChangesetID())) {
            ArrayUtils.reverse((Object[])changesets);
        }
        return changesets;
    }

    @NotNull
    public static Changeset[] queryReverseHistory(@NotNull VersionControlClient vcc, @Nullable String serverOrLocalPath, @Nullable VersionSpec version, @Nullable VersionSpec versionFrom, @Nullable VersionSpec versionTo, int maxCount, boolean includeFileDetails) throws ServerPathFormatException {
        return vcc.queryHistory(serverOrLocalPath, (VersionSpec)(version != null ? version : LatestVersionSpec.INSTANCE), 0, RecursionType.FULL, null, versionFrom, versionTo, maxCount, includeFileDetails, true, false, false);
    }
}

