/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.repository;

import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.webrepository.AbstractWebRepositoryViewer;
import com.atlassian.bamboo.webrepository.CommitUrlProvider;
import com.stellarity.tfs.ProjectInfo;
import com.stellarity.tfs.WebUrlGenerator;
import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsWebRepositoryViewer
extends AbstractWebRepositoryViewer
implements CommitUrlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TfsWebRepositoryViewer.class);

    public Collection<String> getSupportedRepositories() {
        return Arrays.asList("com.stellarity.bamboo.tfs-repository-plugin:tfs");
    }

    public String getHtmlForCommitsFull(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("buildResultsSummary", resultsSummary);
        context.put("repositoryChangeset", repositoryChangeset);
        context.put("repositoryData", repositoryData);
        context.put("linkGenerator", (Object)this);
        return this.templateRenderer.render("templates/plugins/webRepository/defaultCommitView.ftl", context);
    }

    public String getHtmlForCommitsSummary(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData, int maxChanges) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("buildResultsSummary", resultsSummary);
        context.put("repositoryChangeset", repositoryChangeset);
        context.put("repositoryData", repositoryData);
        context.put("linkGenerator", (Object)this);
        context.put("maxChanges", maxChanges);
        return this.templateRenderer.render("templates/plugins/webRepository/commonCommitSummaryView.ftl", context);
    }

    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, RepositoryData repositoryData) {
        ProjectInfo projectInfo = this.getProjectInfo(repositoryData.getId());
        if (projectInfo == null || !projectInfo.isValid()) {
            return "";
        }
        return WebUrlGenerator.createFileUrl(projectInfo, file.getName());
    }

    public String getWebRepositoryUrlForRevision(CommitFile file, RepositoryData repositoryData) {
        ProjectInfo projectInfo = this.getProjectInfo(repositoryData.getId());
        if (projectInfo == null || !projectInfo.isValid()) {
            return "";
        }
        return WebUrlGenerator.createRevisionUrl(projectInfo, file.getRevision(), file.getName());
    }

    public String getWebRepositoryUrlForDiff(CommitFile file, RepositoryData repositoryData) {
        ProjectInfo projectInfo = this.getProjectInfo(repositoryData.getId());
        if (projectInfo == null || !projectInfo.isValid()) {
            return "";
        }
        return WebUrlGenerator.createDiffUrl(projectInfo, file.getRevision(), file.getName());
    }

    public String getWebRepositoryUrlForCommit(Commit commit, RepositoryData repositoryData) {
        return this.getWebRepositoryUrlForRevision(commit.getChangeSetId(), repositoryData);
    }

    public String getWebRepositoryUrlForRevision(String revision, RepositoryData repositoryData) {
        ProjectInfo projectInfo = this.getProjectInfo(repositoryData.getId());
        if (projectInfo == null || !projectInfo.isValid()) {
            return "";
        }
        return WebUrlGenerator.createChangesetUrl(projectInfo, revision);
    }

    public Map<Commit, String> getWebRepositoryUrlForCommits(Collection<Commit> commits, RepositoryData repositoryData) {
        HashMap<Commit, String> commitsToUrls = new HashMap<Commit, String>();
        for (Commit commit : commits) {
            commitsToUrls.put(commit, this.getWebRepositoryUrlForCommit(commit, repositoryData));
        }
        return commitsToUrls;
    }

    @Nullable
    private ProjectInfo getProjectInfo(long repositoryId) {
        ImmutableResultsSummary immutableResultsSummary = this.getImmutableResultsSummary(repositoryId);
        if (immutableResultsSummary == null) {
            return null;
        }
        Map customBuildData = immutableResultsSummary.getCustomBuildData();
        return new ProjectInfo((String)customBuildData.get(String.format("repository.%d.tfs.guid", repositoryId)), customBuildData.containsKey(String.format("repository.%d.tfs.pre2010", repositoryId)), (String)customBuildData.get(String.format("repository.tfs.repositoryUrl", repositoryId)));
    }

    @Nullable
    private ImmutableResultsSummary getImmutableResultsSummary(long repositoryId) {
        Environment env = Environment.getCurrentEnvironment();
        if (env == null) {
            return null;
        }
        try {
            BeanModel resultsSummaryBeanModel = (BeanModel)env.getLocalVariable("resultsSummary");
            if (resultsSummaryBeanModel != null) {
                ImmutableResultsSummary immutableResultsSummary = (ImmutableResultsSummary)resultsSummaryBeanModel.getWrappedObject();
                if (immutableResultsSummary == null) {
                    return null;
                }
                if (immutableResultsSummary.getCustomBuildData().containsKey(String.format("repository.%d.tfs.guid", repositoryId))) {
                    return immutableResultsSummary;
                }
                ImmutableChainResultsSummary immutableChainResultsSummary = (ImmutableChainResultsSummary)immutableResultsSummary;
                if (immutableChainResultsSummary == null) {
                    return null;
                }
                for (ResultsSummary resultsSummary : immutableChainResultsSummary.getOrderedJobResultSummaries()) {
                    if (!resultsSummary.getCustomBuildData().containsKey(String.format("repository.%d.tfs.guid", repositoryId))) continue;
                    return resultsSummary;
                }
                return null;
            }
            BeanModel repositoryChangesetBeanModel = (BeanModel)env.getLocalVariable("repositoryChangeset");
            if (repositoryChangesetBeanModel != null) {
                RepositoryChangeset repositoryChangeset = (RepositoryChangeset)repositoryChangesetBeanModel.getWrappedObject();
                if (repositoryChangeset == null) {
                    return null;
                }
                ImmutableChainResultsSummary immutableChainResultsSummary = (ImmutableChainResultsSummary)repositoryChangeset.getResultsSummary();
                if (immutableChainResultsSummary == null) {
                    return null;
                }
                for (ResultsSummary resultsSummary : immutableChainResultsSummary.getOrderedJobResultSummaries()) {
                    if (!resultsSummary.getCustomBuildData().containsKey(String.format("repository.%d.tfs.guid", repositoryId))) continue;
                    return resultsSummary;
                }
                return null;
            }
        }
        catch (TemplateModelException ex) {
            LOG.error("Caught an exception: ", (Throwable)ex);
        }
        return null;
    }
}

