/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.tfs.optimizator;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.stellarity.tfs.optimizator.DirData;
import com.stellarity.tfs.optimizator.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class RequestOptimizator {
    private final TreeNode<DirData> rootNode;
    private final TreeMap<String, TreeNode<DirData>> nodes = new TreeMap();

    public RequestOptimizator(String rootPath) {
        rootPath = RequestOptimizator.stripLastSlash(rootPath);
        this.rootNode = new TreeNode<DirData>(new DirData(rootPath));
        this.nodes.put(rootPath, this.rootNode);
    }

    public void addIncludedFile(String filePath) {
        TreeNode<DirData> node = this.getOrCreateTreeNode(filePath);
        node.getData().addFile(filePath);
    }

    public void addExcludedFile(String filePath) {
        TreeNode<DirData> node = this.getOrCreateTreeNode(filePath);
        node.getData().setOptimization(DirData.Optimization.None);
    }

    public GetRequest[] createOptimizedRequests(VersionSpec version) {
        RequestOptimizator.optimize(this.rootNode);
        ArrayList<GetRequest> requests = new ArrayList<GetRequest>();
        RequestOptimizator.buildRequests(this.rootNode, version, requests);
        return requests.toArray(new GetRequest[requests.size()]);
    }

    private static void buildRequests(TreeNode<DirData> node, VersionSpec version, List<GetRequest> requests) {
        String dirPath = node.getData().getDirPath();
        if ("$".equals(dirPath)) {
            dirPath = "$/";
        }
        switch (node.getData().getOptimization()) {
            case RecursionFull: {
                requests.add(new GetRequest(new ItemSpec(dirPath, RecursionType.FULL), version));
                return;
            }
            case Recursion0: {
                if (node.getData().getFiles().isEmpty()) break;
                requests.add(new GetRequest(new ItemSpec(dirPath, RecursionType.ONE_LEVEL), version));
                break;
            }
            case None: {
                for (String string : node.getData().getFiles()) {
                    requests.add(new GetRequest(new ItemSpec(string, RecursionType.NONE), version));
                }
                break;
            }
        }
        for (TreeNode treeNode : node.getChildren()) {
            RequestOptimizator.buildRequests(treeNode, version, requests);
        }
    }

    private static void optimize(TreeNode<DirData> node) {
        for (TreeNode<DirData> childNode : node.getChildren()) {
            RequestOptimizator.optimize(childNode);
        }
        if (DirData.Optimization.Unknown == node.getData().getOptimization()) {
            boolean areAllFull = true;
            for (TreeNode<DirData> childNode : node.getChildren()) {
                if (DirData.Optimization.None == childNode.getData().getOptimization()) {
                    node.getData().setOptimization(node.getData().getFiles().isEmpty() ? DirData.Optimization.None : DirData.Optimization.Recursion0);
                    return;
                }
                if (DirData.Optimization.RecursionFull == childNode.getData().getOptimization()) continue;
                areAllFull = false;
            }
            node.getData().setOptimization(areAllFull ? DirData.Optimization.RecursionFull : DirData.Optimization.Recursion0);
        }
    }

    private TreeNode<DirData> getOrCreateTreeNode(String filePath) {
        String parentPath = RequestOptimizator.getParentPath(filePath);
        TreeNode<DirData> node = this.nodes.get(parentPath);
        if (null == node) {
            node = new TreeNode<DirData>(new DirData(parentPath));
            this.nodes.put(parentPath, node);
            TreeNode<DirData> currentNode = node;
            while (null != (parentPath = RequestOptimizator.getParentPath(parentPath))) {
                TreeNode<DirData> parentNode = this.nodes.get(parentPath);
                if (null != parentNode) {
                    parentNode.addChild(currentNode);
                    break;
                }
                parentNode = new TreeNode<DirData>(new DirData(parentPath));
                this.nodes.put(parentPath, parentNode);
                parentNode.addChild(currentNode);
                currentNode = parentNode;
            }
        }
        return node;
    }

    private static String getParentPath(String filePath) {
        int idx = filePath.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        return filePath.substring(0, idx);
    }

    private static String stripLastSlash(String filePath) {
        if (filePath.endsWith("/")) {
            return filePath.substring(0, filePath.length() - 1);
        }
        return filePath;
    }
}

